%define _libexecdir %_prefix/libexec
%define ver_major 3.8
%define gst_api_ver 1.0
%def_enable gnome_bluetooth

Name: gnome-shell
Version: %ver_major.4
Release: alt1.M70P.2

Summary: Window management and application launching for GNOME
Group: Graphical desktop/GNOME
License: GPLv2+
Url: https://live.gnome.org/GnomeShell
Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

#Source: %name-%version.tar
Source: http://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Patch1: %name-3.7.92-alt-gir.patch
Patch3: %name-3.8.4-alt-invalid_user_shell.patch

Obsoletes: gnome-shell-extension-per-window-input-source

Requires: %name-data = %version-%release
Requires: gnome-session >= %ver_major
Requires: dconf gnome-icon-theme gnome-icon-theme-symbolic

%define clutter_ver 1.13.6
%define gjs_ver 1.33.2
%define mutter_ver 3.8.3
%define gtk_ver 3.5.9
%define gio_ver 2.31.6
%define gstreamer_ver 0.11.92
%define eds_ver 3.5.3
%define telepathy_ver 0.17.5
%define telepathy_logger_ver 0.2.4
%define polkit_ver 0.100
%define bluetooth_ver 3.2.0
%define folks_ver 0.5.2
%define gi_ver 0.10.1
%define sn_ver 0.11
%define gcr_ver 3.3.90
%define atspi_ver 2.5.91
%define menus_ver 3.5.3
%define desktop_ver 3.5.1
%define json_glib_ver 0.13.2
%define nm_ver 0.9.6
%define caribou_ver 0.4.8

Requires: mutter-gnome >= %mutter_ver

Requires: ca-certificates
Requires: at-spi2-atk
Requires: caribou

BuildRequires: gnome-common intltool gtk-doc
BuildRequires: python-devel
BuildRequires: libX11-devel libXfixes-devel
BuildRequires: libclutter-devel >= %clutter_ver libclutter-gir-devel
BuildRequires: libdbus-glib-devel
BuildRequires: libgjs-devel >= %gjs_ver
BuildRequires: glib2-devel libgio-devel >= %gio_ver
BuildRequires: at-spi2-atk-devel >= %atspi_ver
BuildRequires: libxml2-devel
BuildRequires: libgnome-menus-devel >= %menus_ver libgnome-menus-gir-devel
BuildRequires: libGConf-devel
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: libgnome-keyring-devel
BuildRequires: gcr-libs-devel >= %gcr_ver
BuildRequires: libstartup-notification-devel >= %sn_ver
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: libcroco-devel
BuildRequires: libcanberra-devel
BuildRequires: libpulseaudio-devel
%{?_enable_gnome_bluetooth:BuildRequires: libgnome-bluetooth-devel >= %bluetooth_ver libgnome-bluetooth-gir-devel gnome-bluetooth}
BuildRequires: evolution-data-server-devel >= %eds_ver
# for screencast recorder functionality
BuildRequires: gstreamer%gst_api_ver-devel >= %gstreamer_ver gst-plugins%gst_api_ver-devel
BuildRequires: libXfixes-devel
BuildRequires: libgtk+3-devel >= %gtk_ver libgtk+3-gir-devel
# used in unused BigThemeImage
BuildRequires: libmutter-devel >= %mutter_ver libmutter-gir-devel
BuildRequires: mutter >= %mutter_ver
BuildRequires: libpolkit-devel >= %polkit_ver
BuildRequires: libtelepathy-glib-devel >= %telepathy_ver libtelepathy-glib-gir-devel libtelepathy-logger-gir-devel
BuildRequires: libtelepathy-logger-devel >= %telepathy_logger_ver
BuildRequires: libfolks-devel >= %folks_ver libfolks-gir-devel
BuildRequires: libnm-gtk-devel >= %nm_ver
BuildRequires: libcaribou-devel >= %caribou_ver
BuildRequires: libcanberra-gtk3-devel
BuildRequires: libgudev-devel libgudev-gir-devel
BuildRequires: gsettings-desktop-schemas-devel >= 0.1.7
BuildRequires: NetworkManager-glib-devel >= 0.8.995 NetworkManager-glib-gir-devel
BuildRequires: libsoup-gir-devel ca-certificates
BuildRequires: gnome-control-center-devel
# for browser plugin
BuildRequires: browser-plugins-npapi-devel

%description
GNOME Shell provides core user interface functions for the GNOME 3 desktop,
like switching to windows and launching applications. GNOME Shell takes
advantage of the capabilities of modern graphics hardware and introduces
innovative user interface concepts to provide a visually attractive and
easy to use experience.

%package data
Summary: Arch independent files for GNOME Shell
Group: Graphical desktop/GNOME
Requires: libmutter-gir >= %mutter_ver
BuildArch: noarch

%description data
This package provides noarch data needed for Gnome Shell to work.

%package devel-doc
Group: Development/Other
Summary: Development documentation for GNOME Shell
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
This package contains documentation needed to develop extensions for
GNOME Shell.

%set_typelibdir %_libdir/%name

%prep
%setup
%patch1 -p1 -b .gir
%patch3 -b .shells

%build
#NOCONFIGURE=1 ./autogen.sh
%configure \
	--enable-gtk-doc \
    --disable-schemas-compile
%make_build

%install
%make DESTDIR=%buildroot \
	mozillalibdir=%browser_plugins_path install

rm -f %buildroot%_libdir/%name/*.la

%find_lang %name

%check
%make check

%files
%_bindir/*
%_libexecdir/gnome-shell-calendar-server
%_libexecdir/gnome-shell-perf-helper
%_libexecdir/gnome-shell-hotplug-sniffer
%dir %_libdir/%name
%_libdir/%name/libgnome-shell.so
%_libdir/%name/libgnome-shell-js.so
%_libdir/%name/*.typelib
# browser plugin
%browser_plugins_path/libgnome-shell-browser-plugin.so
%exclude %browser_plugins_path/libgnome-shell-browser-plugin.la

%files data -f %name.lang
%_datadir/applications/%name.desktop
%_datadir/applications/%name-extension-prefs.desktop
%_datadir/applications/evolution-calendar.desktop
%_datadir/%name/
%_datadir/dbus-1/services/org.gnome.Shell.CalendarServer.service
%_datadir/dbus-1/services/org.gnome.Shell.HotplugSniffer.service
%_datadir/dbus-1/interfaces/org.gnome.ShellSearchProvider.xml
%_datadir/dbus-1/interfaces/org.gnome.Shell.Screenshot.xml
%_datadir/dbus-1/interfaces/org.gnome.ShellSearchProvider2.xml
%_datadir/dbus-1/interfaces/org.gnome.Shell.Screencast.xml
%_datadir/GConf/gsettings/gnome-shell-overrides.convert
%_datadir/gnome-control-center/keybindings/50-gnome-shell-screenshot.xml
%_datadir/gnome-control-center/keybindings/50-gnome-shell-system.xml
%config %_datadir/glib-2.0/schemas/org.gnome.shell.gschema.xml
%_man1dir/*
%doc README NEWS

%files devel-doc
%_datadir/gtk-doc/html/shell/
%_datadir/gtk-doc/html/st/

%changelog
