%define ver_major 3.8
%def_enable systemd

%define _libexecdir %_prefix/libexec

Name: gnome-system-monitor
Version: %ver_major.2
Release: alt1

Summary: Simple process monitor
License: GPLv2+
Group: Monitoring
Url: ftp://ftp.gnome.org
Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# From configure.in
%define glib_ver 2.28.0
%define gtk_ver 3.5.12
%define glibmm_ver 2.28.0
%define libgtkmm3_ver 3.0.0
%define libwnck_ver 3.0.0
%define libgtop_ver 2.28.2
%define libxml_ver 2.0
%define rsvg_ver 2.35
%define gnome_icon_theme_ver 3.0.0
%define systemd_ver 38

BuildPreReq: rpm-build-gnome

# From configure.in
BuildPreReq: gnome-common
BuildPreReq: intltool >= 0.35.0
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libglibmm-devel >= %glibmm_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgtkmm3-devel >= %libgtkmm3_ver
BuildPreReq: libwnck3-devel >= %libwnck_ver
BuildPreReq: libgtop-devel >= %libgtop_ver
BuildPreReq: gnome-icon-theme >= %gnome_icon_theme_ver
BuildPreReq: libxml2-devel >= %libxml_ver
BuildPreReq: librsvg-devel >= %rsvg_ver
BuildPreReq: gnome-doc-utils gnome-common
BuildRequires: yelp-tools
BuildRequires: gcc-c++
%{?_enable_systemd:BuildRequires: systemd-devel libsystemd-login-devel libsystemd-daemon-devel}

%description
Gnome-system-monitor is a simple process and system monitor.

%prep
%setup -q

%build
%autoreconf
%configure \
    --disable-schemas-compile \
    %{subst_enable systemd}

%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libexecdir/%name
%_libexecdir/%name/gsm-kill
%_libexecdir/%name/gsm-renice
%_pixmapsdir/%name/
%_desktopdir/*
%_datadir/%name/
%_datadir/polkit-1/actions/org.gnome.%name.policy
%config %_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gnome-system-monitor.enums.xml


%changelog
