%define ver_major 3.8
%define _libexecdir %_prefix/libexec

%def_with nautilus

Name: gnome-terminal
Version: %ver_major.4
Release: alt1

Summary: GNOME Terminal
License: GPLv3+
Group: Terminals
Url: http://www.gnome.org

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.28.0
%define gtk_ver 3.0.1
%define vte_ver 0.34.7

Provides: xvt

PreReq: libvte3 >= %vte_ver
Requires: common-licenses
Requires: dconf gnome-icon-theme

BuildRequires: gnome-common intltool yelp-tools desktop-file-utils
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libvte3-devel >= %vte_ver

BuildRequires: gsettings-desktop-schemas-devel gnome-doc-utils-xslt libgio-devel libSM-devel
BuildRequires: libdconf-devel libuuid-devel
%{?_with_nautilus:BuildRequires: libnautilus-devel}
# for migration
BuildRequires: libGConf-devel

%description
GNOME terminal emulator application.

%package nautilus
Summary: Nautilus extension for the GNOME Terminal
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description nautilus
This package provides integration with the GNOME Terminal for the
Nautilus file manager.

%prep
%setup -q

# license
%__rm -f COPYING
%__ln_s -f %_licensedir/GPL-3 COPYING

%build
%autoreconf
%configure \
	--disable-static \
	--disable-schemas-compile \
	--disable-dependency-tracking \
	%{?_with_nautilus:--with-nautilus-extension}

%make_build

%install
%makeinstall_std

# alternatives
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xvt	%_bindir/%name	40
EOF

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-migration
%_libexecdir/%name-server
%_datadir/applications/%name.desktop
%_datadir/dbus-1/services/org.gnome.Terminal.service
%config %_datadir/glib-2.0/schemas/org.gnome.Terminal.gschema.xml
%_altdir/%name
%doc --no-dereference COPYING
%doc AUTHORS NEWS

%if_with nautilus
%files nautilus
%_libdir/nautilus/extensions-3.0/libterminal-nautilus.so
%exclude %_libdir/nautilus/extensions-3.0/libterminal-nautilus.la
%endif

%changelog
