%define ver_major 3.8

Name: gnome-tweak-tool
Version: %ver_major.1
Release: alt1

Summary: A tool to customize advanced GNOME 3 options
Group: Graphical desktop/GNOME
License: GPLv3
Url: https://live.gnome.org/GnomeTweakTool
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %name-%version.tar.xz
Patch: gnome-tweak-tool-3.8.0-alt-desktop.patch

BuildArch: noarch
Requires: gnome-shell >= %ver_major

BuildRequires: GConf gnome-common intltool libgio-devel
BuildRequires: gsettings-desktop-schemas-devel >= 3.4.0
BuildRequires: python-module-pygobject3-devel >= 3.2.1

%description
GNOME Tweak Tool is an application for changing the advanced settings
of GNOME 3.

Features:
* Install and switch gnome-shell themes
* Switch GTK+ themes
* Switch icon themes
* Change
  - The user-interface and title bar fonts
  - Icons in menus and buttons
  - Behavior on laptop lid close
  - Shell font size
  - File manager desktop icons
  - Title bar click action
  - Shell clock to show date
  - Font hinting
  - Font anti-aliasing

%prep
%setup
%patch -b .desktop

%build
#NOCONFIGURE=1 ./autogen.sh
%configure --disable-schemas-compile
%make_build

%install
%make_install install DESTDIR=%buildroot

%find_lang %name

%files -f %name.lang
%_bindir/%name
%python_sitelibdir/gtweak
%_datadir/applications/%name.desktop
%_datadir/%name
%_iconsdir/hicolor/*/*/*.png
%doc AUTHORS NEWS README

%changelog
