%define _libexecdir /usr/libexec

Name: gnote
Version: 3.8.1
Release: alt1
Summary: Note-taking application
Group: Graphical desktop/GNOME
License: GPLv3+
Url: http://live.gnome.org/Gnote
Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Source0: http://ftp.gnome.org/pub/GNOME/sources/gnote/%version/%name-%version.tar

%define gtk_ver 3.6
%define gtkmm_ver 3.6
%define glibmm_ver 2.28
%define gtkspell_ver 3.0.0
%define libsecret_ver 0.8

BuildRequires: gcc-c++ boost-devel
BuildRequires: gnome-common yelp-tools intltool
BuildRequires: pkgconfig(glibmm-2.4)  >= %glibmm_ver
BuildRequires: pkgconfig(gtk+-3.0) >= %gtk_ver
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(gtkmm-3.0) >= %gtkmm_ver
BuildRequires: pkgconfig(glib-2.0) >= 2.32
BuildRequires: pkgconfig(libxml-2.0) pkgconfig(libxslt)
BuildRequires: pkgconfig(gtkspell3-3.0) >= %gtkspell_ver
BuildRequires: pkgconfig(libsecret-1) >= %libsecret_ver
BuildRequires: pkgconfig(uuid)
BuildRequires: desktop-file-utils

%description
Gnote is a desktop note-taking application which is simple and easy to use.
It lets you organize your notes intelligently by allowing you to easily link
ideas together with Wiki style interconnects. It is a port of Tomboy to C++
and consumes fewer resources.

%prep
%setup -q

%build
NOCONFIGURE=1 ./autogen.sh
%configure --disable-static

%make_build

%install
%make DESTDIR=%buildroot install

desktop-file-install \
 --dir=%buildroot%_datadir/applications \
%buildroot/%_datadir/applications/gnote.desktop

%find_lang %name --with-gnome

%check
%make check

%files -f %name.lang
%doc COPYING README TODO NEWS AUTHORS
%_bindir/%name
%_libdir/libgnote-*.so.*
%_man1dir/%name.*
%_desktopdir/%name.desktop
%_datadir/%name
%_iconsdir/hicolor/*/apps/%name.??g
%_libdir/gnote
%exclude %_libdir/gnote/addins/*/*.la
%_datadir/dbus-1/services/org.gnome.Gnote.service
%_datadir/glib-2.0/schemas/*.xml

%changelog
