Name: gnotime
Version: 2.3.0
Release: alt8.20121130
Summary: Tracks and reports time spent

Group: Office
License: GPLv3+
Url: http://gttr.sourceforge.net/
Source0: %name-%version.tar
Source1: gnome-cromagnon.png
Patch2: %name-2.3.0-alt-freedesktop.patch

Packager: Sergey Kurakin <kurakin@altlinux.org>

BuildPreReq: rpm-build-xdg

BuildRequires: ImageMagick-tools gcc-c++ libguile20-devel intltool libXScrnSaver-devel libdbus-glib-devel libglade-devel libgnomeui-devel libgtkhtml3-devel libqof-devel librarian libxml2-devel

%description
The Gnome Time Tracker is a to-do list/diary/journal tool that can track
the amount of time spent on projects, and, among other things, generate
reports and invoices based on that time. It's being used it to keep
shopping lists, organize ideas, track bug reports, keep a diary
of activities, do some blogging, provide weekly status reports
to management, and even as a consultant billing system.

%prep
%setup -q
%patch2 -p1

cat > %name.menu << EOF
<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
	"http://www.freedesktop.org/standards/menu-spec/1.0/menu.dtd">
<Menu>
	<Menu>
	<Name>Development</Name>
	<Exclude>
		<Filename>%name.desktop</Filename>
	</Exclude>
	</Menu>
</Menu>
EOF

%build
%autoreconf
%configure
%make_build
convert -resize 16x16 %SOURCE1 %name-16.png
convert -resize 32x32 %SOURCE1 %name-32.png

%install
%make_install install DESTDIR=%buildroot
install -D -m 644 %name-16.png %buildroot%_miconsdir/%name.png
install -D -m 644 %name-32.png %buildroot%_niconsdir/%name.png
install -D -m 644 %SOURCE1 %buildroot%_liconsdir/%name.png
install -D -m 644 %name.menu %buildroot%_xdgmenusdir/applications-merged/%name.menu

# Gnotime puts it's locale translations into gnotime-2.0.mo but it's gnome
# help files into html/gnotime....
%find_lang %name --with-gnome
%find_lang %name-2.0 --with-gnome
cat %name-2.0.lang >> %name.lang

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall %name
fi

%files -f %name.lang
%doc AUTHORS ChangeLog INSTALL NEWS README TODO
%config %_sysconfdir/gconf/schemas/*
%_bindir/*
%_datadir/%name
%_datadir/applications/%name.desktop
%_man1dir/*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_xdgmenusdir/applications-merged/%name.menu

%changelog
