%define origname gnu-efi
%define flavour 3.0u

Name: %origname-%flavour
Version: %flavour
Release: alt3

Summary: Building EFI applications using the GNU toolchain
# Intel and HP's BSD-like license, except setjmp code coming from GRUB
License: GPL v2+ (setjmp code), BSD-like (all the rest)
Group: Development/Other

Url: http://gnu-efi.sourceforge.net/
Source: http://downloads.sourceforge.net/gnu-efi/%{origname}_%version.orig.tar.gz

BuildRequires: binutils >= 2.17.50.0.14
BuildRequires: gcc >= 4.1.1
Requires: binutils >= 2.17.50.0.14
Requires: gcc >= 4.1.1
ExclusiveArch: %ix86 x86_64 ia64

Summary(pl.UTF-8): Tworzenie aplikacji EFI przy użyciu narzędzi GNU

%description
GNU-EFI development environment allows to create EFI applications
for IA-64 and x86 platforms using the GNU toolchain.

%description -l pl.UTF-8
Rodowisko programistyczne GNU-EFI umożliwia tworzenie aplikacji EFI
dla platform IA-64 i x86 przy użyciu narzędzi GNU.

%prep
%setup -n %origname-3.0
# upstream recommendation as of 20130130
sed -i 's/-DGNU_EFI_USE_MS_ABI -maccumulate-outgoing-args//' Make.defaults

%build
%make -j1 \
	ARCH=$(arch | sed -e 's/i.86/ia32/') \
	CFLAGS="%optflags -fpic -Wall -fno-stack-protector" \
	OBJCOPY=objcopy

%install
%make install INSTALLROOT=%buildroot PREFIX=%prefix

%if "%_lib" != "lib"
mv -f %buildroot%prefix/{lib,%_lib}
%endif

%files
%doc ChangeLog README.* apps
%_libdir/libefi.a
%_libdir/libgnuefi.a
%_libdir/crt0-efi-*.o
%_libdir/elf_*_efi.lds
%_includedir/efi

%changelog
