%define _name gnubiff

%def_with password

Name: %_name
Version: 2.2.11
Release: alt3.1.qa1

Summary: gnubiff is a mail notifier that displays headers when new mail has arrived.
License: %gpl3plus w/exception for OpenSSL
Group: Networking/Mail
Url: http://gnubiff.sourceforge.net

Source: http://downloads.sourceforge.net/%_name/%_name-%version.tar.gz
Source2: %name.desktop
Patch: %_name-2.2.9-alt-tls-support.patch
#Patch1: %_name-2.2.9-fix-build.patch
Patch3: %_name-2.2.11-fix-building.patch
Patch4: gnubiff-2.2.11-alt-DSO.patch

BuildPreReq: rpm-build-licenses

# From configure.ac
BuildPreReq: libgamin-devel >= 0.1.0
BuildPreReq: libgtk+2-devel >= 2.6
BuildPreReq: glib2-devel >= 2.4
BuildPreReq: libglade2-devel >= 2.3
BuildPreReq: libpopt-devel

BuildRequires: gcc-c++ libxml2-devel perl-XML-Parser

%description
gnubiff is a mail notification program that checks for mail and displays
headers when new mail has arrived. This package contains Gtk+ version that
does not need a GNOME panel to work.

gnubiff features include:

    * Multiple mailbox support
    * pop3, apop, imap4, mh, qmail and mailfile support
    * SSL & certificates support
    * GNOME support with complete integration to panel
    * GTK stand-alone support
    * Automatic detection of mailbox format
    * Mail header & content display
    * IDLE state support for imap4
    * FAM support for mh/qmail/mailfile
    * PNG animation support
    * Highly configurable
    * Spam filtering
    * HIG 2.0 compliance
    * Small memory usage

%prep
%setup -q -n %_name-%version
%patch -p1 -b .alt-tls-support
#patch1 -p0 -b .fix-build
%patch3 -p0 -b .fix-building
%patch4 -p2

%build
%configure \
    %{subst_with password} \
    %{?_with_password:--with-password-string="andthentherewere3"} \
    --enable-expert \
    --disable-gnome

%make_build

%install
%makeinstall_std
install -pD -m644 %SOURCE2 %buildroot%_desktopdir/%name.desktop

%find_lang %_name

%files -f %_name.lang
%_bindir/%_name
%dir %_datadir/%_name
%_datadir/%_name/*
%_pixmapsdir/*
%_desktopdir/*.desktop
%_infodir/*.info*
%_man1dir/*
%doc README ChangeLog COPYING THANKS TODO NEWS AUTHORS

%changelog
