Name: gnupg2
Version: 2.0.22
Release: alt1

Group: Text tools
Summary: The GNU Privacy Guard suite
License: GPLv3+
Url: http://www.gnupg.org/

# ftp://ftp.gnupg.org/gcrypt/gnupg/gnupg-%version.tar.bz2
Source0: gnupg-%version.tar
Source1: gnupg-agent.sh
Source2: gnupg-agent-wrapper.sh

Patch1: gnupg-1.6.9-xloadimage.patch
Patch2: gnupg-1.9.20-alt-libpcsclite.patch
Patch3: gnupg-2.0.18-alt-agent-fix-password-request.patch
Patch4: gnupg-2.0.19-alt-texinfo.patch
Patch11: gnupg-2.0.18-rh-protect-tool-env.patch
Patch12: gnupg-2.0.20-rh-ocsp-keyusage.patch

%define docdir %_docdir/gnupg-%version

Provides: newpg = %version-%release
Obsoletes: newpg < %version-%release

Provides: gnupg-agent = %version-%release
Provides: %name-agent = %version-%release
Provides: %name-gpg = %version-%release
Provides: %name-common = %version-%release
Obsoletes: %name-agent < %version-%release
Obsoletes: %name-common < %version-%release

# due to "enable -f /usr/lib/bash/lockf lockf"
Requires: bash-builtin-lockf >= 0:0.2

BuildRequires: libgcrypt-devel >= 1.4, libksba-devel >= 0.9.13

# Automatically added by buildreq on Fri Apr 08 2011
BuildRequires: bzlib-devel libassuan-devel libcurl-devel libgcrypt-devel libksba-devel libldap-devel libpth-devel libreadline-devel zlib-devel

%description
GnuPG is GNU's tool for secure communication and data storage.  It can
be used to encrypt data and to create digital signatures.  It includes
an advanced key management facility and is compliant with the proposed
OpenPGP Internet standard as described in RFC2440 and the S/MIME
standard as described by several RFCs.

GnuPG 2.0 is a newer version of GnuPG with additional support for
S/MIME.  It has a different design philosophy that splits
functionality up into several modules.

%prep
%setup -n gnupg-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch11 -p1
%patch12 -p1
rm doc/*.info*

%build
%add_optflags -fno-strict-aliasing
%configure \
	--disable-rpath \
	--with-capabilities \
	--enable-symcryptrun \
	--with-mailprog=%_sbindir/sendmail \
	--with-pinentry-pgm=%_bindir/pinentry \
	--libexecdir=%_libexecdir/gnupg \
	--docdir=%docdir
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std

install -pDm755 %_sourcedir/gnupg-agent.sh \
	%buildroot%_sysconfdir/profile.d/gnupg-agent.sh
sed -i 's|@LIBEXECDIR@|%_libexecdir|g' \
	%buildroot%_sysconfdir/profile.d/gnupg-agent.sh
install -pDm755 %_sourcedir/gnupg-agent-wrapper.sh \
	%buildroot%_libexecdir/gnupg/gnupg-agent-wrapper

mv %buildroot%_infodir/gnupg{,2}.info

install -pm644 AUTHORS NEWS THANKS %buildroot%docdir/

%find_lang %name

%check
%make_build -k check

%files -f %name.lang
%config %_sysconfdir/profile.d/gnupg-agent.sh
%_bindir/*
%_sbindir/*
%_libexecdir/gnupg/
%_datadir/gnupg/
%_infodir/*.info*
%_mandir/man?/*
%exclude %_man1dir/gpg-zip.*
%docdir

%changelog
