Name: gnuplot
Version: 4.4.0
Release: alt2.qa1
Epoch: 1

Summary: A program for plotting mathematical expressions and data
Summary (ru_RU.UTF-8): Программа для построения графиков математических выражений и данных
License: Freeware-like
Group: Sciences/Other
URL: http://gnuplot.sourceforge.net/
Packager: Alexey Morsov <swi@altlinux.ru>

Source0: %name-%version.tar
Source2: http://www.gnuplot.info/faq/%name-faq.html.bz2
Source3: %name.desktop
Source4: %name.menu

Source10: %name.16.png
Source11: %name.32.png
Source12: %name.48.png

Source14: gnuplot-emacs.el

Patch1: gnuplot-4.2.4-build.alt.patch

BuildRequires(pre): rpm-build-texmf 
BuildPreReq: desktop-file-utils
BuildRequires: gcc-c++ ghostscript-module-X groff-base imake libXt-devel libncurses-devel libreadline-devel tetex-latex xorg-cf-files zlib-devel libgd2-devel libpng-devel libjpeg-devel
BuildRequires: tetex-core tetex-dvips
# for wxt terminal
BuildRequires: libwxGTK-devel libcairo-devel libpango-devel
# for lua/TikZ
BuildRequires: liblua5-devel texmf-pgf

Requires(post,postun): desktop-file-utils 


%package -n emacs-mode-%name
Summary: A GNU Emacs major mode for %name
Summary(ru_RU.UTF-8): Основной режим GNU Emacs для %name
BuildArch: noarch
BuildPreReq: emacs-devel >= 0.0.1-alt2
BuildRequires: emacs-common texinfo
Group: Editors
Requires: %name = %{?epoch:%epoch:}%version-%release emacs-base
Obsoletes: emacs-gnuplot <= 0.6.0-alt1
Provides: emacs-gnuplot

%package -n emacs-mode-%name-el
Summary:  The Emacs Lisp sources for bytecode included in emacs-mode-%name
Summary(ru_RU.UTF-8): Исходный код Emacs Lisp для emacs-mode-%name
BuildArch: noarch
Group: Development/Other
Requires: emacs-mode-%name = %{?epoch:%epoch:}%version-%release
Obsoletes: emacs-gnuplot <= 0.6.0-alt1
Provides: emacs-gnuplot-el

%description
Gnuplot is a command-line driven, interactive function plotting program
especially suited for scientific data representation. Gnuplot can be used to
plot functions and data points in both two and three dimensions and in many
different formats.

Install gnuplot if you need a graphics package for scientific data
representation.

%description -l ru_RU.UTF-8
Gnuplot это интерактивная программа, предназначенная для построения
графиков.  Она особенно хорошо подходит для представления научных 
данных.  Gnuplot может строить 2-х и 3-х мерные графики функций 
и числовых данных во множестве различных графических форматов.

%description -n emacs-mode-%name
A GNU Emacs major mode for %name

%description -n emacs-mode-%name -l ru_RU.UTF-8
Основной режим GNU Emacs для %name

%description -n emacs-mode-%name-el
The Emacs Lisp sources for bytecode included in %name

%description -n emacs-mode-%name-el -l ru_RU.UTF-8
Исходный код Emacs Lisp для emacs-mode-%name


%prep
%setup -q 
%patch1 -p1


%build
#export CFLAGS="$RPM_OPT_FLAGS -fno-fast-math"
%configure --prefix=%{_prefix} --with-readline=gnu --with-png --with-gif=png --without-linux-vga \
	--with-cdrwc --without-row-help --enable-thin-splines \
	--with-texdir=%buildroot%{_texmfmain}/%{name} \
	--with-lua \
	--with-gihdir=%{name}/4.4/
#find -type f -print0 |
#	xargs -r0 fgrep -l gdImageGif |
#	xargs perl -pi -e 's/gdImageGif/gdImagePng/g'

# due to some problems with building on i586 in SMP mode turn it off to noSMP
%make_build

pushd lisp
	#./configure --prefix=%{_prefix} --datadir=%{_datadir} --with-emacs=emacs --infodir=%{_infodir} \
	./configure --prefix=%{_prefix} --with-emacs=emacs --infodir=%{_infodir} \
	%make_build
popd

install -p -m644 %SOURCE2 .
bunzip *.html.bz2

pushd tutorial
    make pdf
#    pdflatex tutorial
popd

pushd docs
    make pdf
    pdftex gpcard
popd


%install
%makeinstall

pushd lisp
    mkdir -p %buildroot%{_emacslispdir}/%name
    install -m 644 *.el* $RPM_BUILD_ROOT%{_emacslispdir}/%name
    mkdir -p %buildroot/etc/emacs/site-start.d
    install -m 644 %SOURCE14 %buildroot/etc/emacs/site-start.d/gnuplot.el
    %add_lisp_loadpath %buildroot%_emacslispdir/%name
    %byte_recompile_lispdir
    make pdf
    make ps
    mkdir -p %buildroot%_defaultdocdir/emacs-%{name}-%{version}
    install -m 644 COPYING ChangeLog README README.1st gpelcard.pdf gpelcard.ps %buildroot%_defaultdocdir/emacs-%{name}-%{version}/
popd

# menus
install -D -pm644 %SOURCE3  %buildroot%_desktopdir/%name.desktop

# icon
install -D -pm644 %SOURCE10  %buildroot/%_miconsdir/%name.png
install -D -pm644 %SOURCE11  %buildroot/%_niconsdir/%name.png
install -D -pm644 %SOURCE12  %buildroot/%_liconsdir/%name.png


%files
%doc README ChangeLog BUGS Copyright NEWS
%doc demo tutorial/tutorial.pdf gnuplot-faq.html
%doc docs/psdoc docs/gpcard.pdf docs/gnuplot.pdf
%_bindir/*
%_mandir/man?/*
%_libexecdir/%name
%_datadir/%name
%_desktopdir/*
%_infodir/%{name}*
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png
%_texmfmain/%name

%files -n emacs-mode-%name
%dir %_defaultdocdir/emacs-%{name}-%{version}/
%_defaultdocdir/emacs-%{name}-%{version}/*
%dir %_emacslispdir/*.elc
%_emacslispdir/%name/*.elc
%config(noreplace) /etc/emacs/site-start.d/gnuplot.el

%files -n emacs-mode-%name-el
%_emacslispdir/*.el
%_emacslispdir/%name/*.el

%changelog
