%set_verify_elf_method unresolved=strict

Name: gnustep-Etoile-DocGenerator
Version: 0.1
Release: alt2.git20140227.M70T.1
Summary: Etoile Doc Generator
License: BSD
Group: Graphical desktop/GNUstep
Url: http://etoileos.com/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/etoile/DocGenerator.git
Source: %name-%version.tar

BuildPreReq: clang-devel gnustep-make-devel libgnustep-objc2-devel /proc
BuildPreReq: gnustep-gui-devel gnustep-Etoile-devel
BuildPreReq: libgmp-devel libgnutls-devel libgcrypt-devel
BuildPreReq: libxslt-devel libffi-devel libicu-devel zlib-devel
BuildPreReq: discount graphviz libgraphviz-devel
BuildPreReq: gnustep-Etoile-EtoileFoundation-devel
BuildPreReq: gnustep-Etoile-SourceCodeKit-devel

Requires: gnustep-back gnustep-back-doc Io-language
Requires: gnustep-Etoile-DevDoc discount graphviz
Requires: gnustep-Etoile-EtoileFoundation gnustep-Etoile-SourceCodeKit

%description
etdocgen (Etoile Doc Generator) is a command-line tool that can generate
HTML pages from various source documents and templates.

Its main use case is to generate the Etoile documentation; it reads
gsdoc files (which are files containing an XML representation of a
source code, generated by the ``autogsdoc`` tool from GNUstep), and
splits or consolidates them into pages based on various rules. In the
end, it generates a HTML representation of each page by combining
different other files (as specified by the page template):

*  a HTML template (option ``-t``)
*  a menu file (option ``-m``)

%prep
%setup

cp %_libdir/GNUstep/Etoile/* ~/RPM/

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh 

%make \
	messages=yes \
	debug=yes \
	strip=no \
	documentation=yes \
	PROJECT_NAME=DocGenerator

%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh 

%makeinstall_std GNUSTEP_INSTALLATION_DOMAIN=SYSTEM \
	documentation=yes \
	PROJECT_NAME=DocGenerator

install -d %buildroot%_libdir/GNUstep/DocGenerator
cp -fR Templates TestFiles \
	%buildroot%_libdir/GNUstep/DocGenerator/

cat <<EOF >%buildroot%_bindir/prepare_docgen
#!/bin/sh

mkdir -p /usr/src/RPM/Developer/Documentation
install -m755 %_datadir/GNUstep/DevDoc/*.sh \
	/usr/src/RPM/Developer/Documentation/

mkdir -p /usr/src/RPM/Developer/Services
cp -fR %_libdir/GNUstep/DocGenerator \
	/usr/src/RPM/Developer/Services/
EOF
chmod +x %buildroot%_bindir/prepare_docgen

install -m755 objcrewriter.io %buildroot%_bindir/

%files
%doc NEWS README SYNTAX TODO Documentation/*
%_bindir/*
%_libdir/GNUstep

%changelog
