%set_verify_elf_method unresolved=strict

Name: gnustep-base
Version: 1.24.6
Release: alt3.svn20140126.M70T.1
Epoch: 1

Summary: GNUstep Base library package

License: LGPL
Group: Development/Objective-C
Url: http://www.gnustep.org/

# http://svn.gna.org/svn/gnustep/libs/base/trunk/
Source: %name-%version.tar
Source1: %name.init

Requires: lib%name = %epoch:%version-%release

BuildRequires: gnustep-make gnustep-make-devel libgnutls-devel
BuildRequires: libgnustep-objc2-devel pkgconfig clang-devel libssl-devel
BuildRequires: libxml2-devel libxslt-devel zlib-devel libffi-devel mount
BuildPreReq: libffcall-devel libgmp-devel libbfd-devel libgcrypt-devel
Requires: gnustep-make >= 2.0.6-alt4 glibc-locales glibc-gconv-modules
BuildPreReq: libicu-devel libcommoncpp2-devel /proc
BuildPreReq: texinfo texi2html texlive-latex-base gnustep-make-doc

%description
The GNUstep Base Library is a powerful fast library of general-purpose,
non-graphical Objective C classes, inspired by the superb OpenStep API but
implementing Apple and GNU additions to the API as well.  It includes for
example classes for unicode strings, arrays, dictionaries, sets, byte
streams, typed coders, invocations, notifications, notification dispatchers,
scanners, tasks, files, networking, threading, remote object messaging
support (distributed objects), event loops, loadable bundles, attributed
unicode strings, xml, mime, user defaults. This package includes development
headers too.

%package -n lib%name
Summary: Shared libraries of %name
Group: System/Libraries
Conflicts: %name < %epoch:%version-%release

%description -n lib%name
Shared libraries of %name.

%package devel
Summary: Header files and static libraries from %name
Group: Development/Objective-C
Requires: %name = %epoch:%version-%release
Requires: lib%name = %epoch:%version-%release

%description devel
Libraries and includes files for developing programs based on %name.

%package doc
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: gnustep-make-doc

%description doc
Development documentation for %name.

%prep
%setup
#cp -fR Headers/ObjectiveC2/objc Headers/ObjectiveC2/objc2
%define _libexecdir %_libdir

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh
%undefine __libtoolize

%{expand:%%add_optflags %(pkg-config --cflags libffi) -D__GNUSTEP_RUNTIME__}
%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-pass-arguments \
	--with-openssl-include=%_includedir/openssl \
	--with-openssl-library=/%_lib/ \
	CC=clang CXX=clang++

%make \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes

export LD_LIBRARY_PATH=$PWD/Source/obj
%make_build -C Documentation \
	messages=yes

%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%make install \
	INSTALL_ROOT_DIR=%buildroot \
	GNUSTEP_INSTALLATION_DOMAIN=SYSTEM \
	DESTDIR=%buildroot

%makeinstall_std -C Documentation \
     GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

install -d %buildroot%_initdir
sed -e "s!@TOOLSARCHDIR@!%prefix/System/Tools!" %SOURCE1 > %buildroot%_initdir/gdomap
rm -Rf %buildroot%_libexecdir/GNUstep/Libraries/gnustep-base/Versions/1.14/Resources/NSTimeZones/

# It is the file in the package whose name matches the format emacs or vim uses 
# for backup and autosave files. It may have been installed by  accident.
find $RPM_BUILD_ROOT \( -name '*.swp' -o -name '#*#' -o -name '*~' \) -print -delete
# failsafe cleanup if the file is declared as %%doc
find . \( -name '*.swp' -o -name '#*#' -o -name '*~' \) -print -delete

for i in ChangeLog*; do
	gzip $i
done

%post
grep -q '^gdomap' /etc/services \
|| (echo "gdomap 538/tcp # GNUstep distributed objects" >> /etc/services \
&& echo "gdomap 538/udp # GNUstep distributed objects" >> /etc/services)


%postun
mv -f /etc/services /etc/services.orig
grep -v "^gdomap 538" /etc/services.orig > /etc/services
rm -f /etc/services.orig

%files
%_initdir/gdomap
%doc ANNOUNCE COPYING COPYING.LIB ChangeLog*
%doc NEWS README
%_bindir/*
%_libdir/GNUstep/*
%_man1dir/*
%_man8dir/*

%files -n lib%name
%_libdir/libgnustep-base.so.*

%files devel
%_datadir/GNUstep/Makefiles/Additional/base.make
%_libdir/libgnustep-base.so
%_includedir/Foundation
%_includedir/GNUstepBase
%_includedir/gnustep

%files doc
%_docdir/GNUstep
%_infodir/*
 
%changelog
