%set_verify_elf_method unresolved=strict

# based on Fedora's package

Name: gnustep-gui
Version: 0.24.0
Release: alt3.svn20140126.M70T.1
Summary: The GNUstep GUI library
License: GPLv2+ and GPLv3
Group: Development/Tools
Url: http://www.gnustep.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/gnustep/gnustep-gui.git
Source: %name-%version.tar

BuildPreReq: clang-devel gnustep-make-devel gnustep-base-devel
BuildPreReq: libgnustep-objc2-devel libtiff-devel libjpeg-devel
BuildPreReq: libpng-devel libcups-devel libaspell-devel aspell
BuildPreReq: libungif-devel libaudiofile-devel libportaudio2-devel
BuildPreReq: libX11-devel libicu-devel imake libImageMagick-devel
BuildPreReq: ImageMagick-tools libsndfile-devel libao-devel
BuildPreReq: flite-devel libicns-devel /proc gnustep-base-doc
BuildPreReq: texinfo texi2html texlive-latex-base
BuildPreReq: libgmp-devel libgnutls-devel libgcrypt-devel
BuildPreReq: libxslt-devel libffi-devel libdispatch-objc2-devel

Requires: lib%name = %version-%release
Requires: aspell flite

%description
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

%package -n lib%name
Summary: Libraries for %name
Group: System/Libraries
License: LGPLv2+ and LGPLv3+

%description -n lib%name
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

This package contains the libraries for %name.

%package devel
Summary: Header files for the gnustep-gui package
Group: Development/Objective-C
Requires: gnustep-base-devel
Requires: lib%name = %version-%release
Requires: %name = %version-%release

%description devel
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

This package contains the header files for gnustep-gui.

%package doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch
License: GFDL
Requires: gnustep-base-doc
#Requires: %name = %version-%release

%description doc
The GNUstep GUI library is a library of graphical user interface classes
written completely in the Objective-C language; the classes are based
upon the OpenStep specification as release by NeXT Software, Inc.  These
classes include graphical objects such as buttons, text fields, popup
lists, browser lists, and windows; there are also many associated
classes for handling events, colors, fonts, pasteboards and images.

This package contains the documentation for %name.

%prep
%setup

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-imagemagick \
	--with-x \
	--with-installation-domain=SYSTEM

#make_build \
#	messages=yes \
#	debug=yes \
#	strip=no \
#	shared=yes \
#	AUXILIARY_CPPFLAGS='-O2 -DGNUSTEP' \
#	||:
#touch Tools/GSspell.service/Resources/Info-gnustep.plist
%make_build \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes \
	AUXILIARY_CPPFLAGS='-I%_includedir/dispatch'
 
%make_build -C Documentation \
	messages=yes

%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%makeinstall_std GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

%makeinstall_std -C Documentation \
     GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

for i in ChangeLog*; do
	gzip $i
done

# broken info
rm -fR %buildroot%_infodir

%files
%doc ANNOUNCE BUGS ChangeLog* COPYING NEWS README
%_bindir/*
%_libdir/GNUstep
%_man1dir/*

%files -n lib%name
%doc COPYING.LIB
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_datadir/GNUstep

%files doc
#_infodir/*
%_docdir/GNUstep

%changelog
