Name: gnustep-make
Version: 2.6.6
Release: alt14.svn20140116.M70T.1
# http://svn.gna.org/svn/gnustep/tools/make/trunk
Source: %name-%version-%release.tar
License: GPLv3+
Group: Development/Objective-C
Summary: GNUstep Makefile package
Url: http://www.gnustep.org/

BuildRequires: clang-devel libgnustep-objc2-devel star
BuildPreReq: texlive-latex-base texi2html

Requires: gnustep-dirs

%description
This package contains the basic scripts, makefiles and directory
layout needed to run and compile any GNUstep software.
This package was configured using flattened mode using the system
GNUstep filesystem layout.

%package devel
Summary: Files needed to develop applications with gnustep-make
Group: Development/Objective-C
BuildArch: noarch
Requires: %name = %version-%release

%description devel
The makefile package is a simplistic, powerful and extensible way to
write makefiles for a GNUstep-based project. It allows the user to
write a GNUstep-based project without having to deal with the complex
issues associated with the configuration and installation of the core
GNUstep libraries. It also allows the user to easily create
cross-compiled binaries.

%package doc
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description doc
This package contains development documentation for %name.

%prep
%setup -n %name-%version-%release

%ifarch x86_64
LIB_SUFF=64
%endif
sed -i "s|@64@|$LIB_SUFF|g" FilesystemLayouts/fhs-system-alt

%build
export CC=clang CXX=clang++ CPP='clang -E'
OBJCFLAGS="%optflags -fobjc-runtime=gnustep-1.7 -fobjc-nonfragile-abi"
export OBJCFLAGS="$OBJCFLAGS -DGNUSTEP -DGNU_RUNTIME -mtune=%_arch"
%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-flattened \
	--with-layout=fhs-system-alt \
	--with-objc-lib-flag=-lobjc2 \
	--enable-objc-nonfragile-abi \
	--enable-native-objc-exceptions \
	--enable-debug-by-default

%make_build -C Documentation \
	GNUSTEP_MAKEFILES=$PWD

%install
sed -i 's|/usr/sbin/lsattr|lsattr|g' config.guess
%makeinstall_std

%makeinstall_std -C Documentation \
	GNUSTEP_MAKEFILES=$PWD

%ifarch x86_64
sed -i 's|-march=i586||g' $(find %buildroot -type f -not -name config.guess -not -name config.sub)
sed -i 's|-mtune=i586||g' $(find %buildroot -type f)
%endif
sed -i 's|-mtune=generic||g' \
	%buildroot%_datadir/GNUstep/Makefiles/config.make

if grep -Fle %_target_cpu $(find %buildroot%_datadir/GNUstep -type f -not -name config.guess -not -name config.sub -not -name config.make); then
       echo >&2 %buildroot is dirty
       exit 1
fi

install -d %buildroot/etc/profile.d

cat > %buildroot/etc/profile.d/GNUstep.sh << EOF
#!/bin/sh
. %_datadir/GNUstep/Makefiles/GNUstep.sh

if [ ! -d \$GNUSTEP_USER_ROOT ]; then
        mkdir \$GNUSTEP_USER_ROOT
        chmod +rwx \$GNUSTEP_USER_ROOT
        . %_datadir/GNUstep/Makefiles/GNUstep.sh
fi
EOF

sed -i 's|\-march=[0-9a-z_]*||g' $(find %buildroot -type f)

gzip ChangeLog

# broken
rm -f %buildroot%_infodir/*

%files
%doc ChangeLog*
%_sysconfdir/GNUstep/
%_bindir/*
%attr(755,root,root) %_sysconfdir/profile.d/*
%dir %_datadir/GNUstep
%dir %_datadir/GNUstep/Makefiles
%dir %_datadir/GNUstep/Makefiles
%attr(755,root,root) %_datadir/GNUstep/Makefiles/*.csh
%attr(755,root,root) %_datadir/GNUstep/Makefiles/*.sh
#%attr(755,root,root) %_datadir/Tools
%_datadir/GNUstep/Makefiles/tar-exclude-list
%_datadir/GNUstep/Makefiles/config.guess
%_datadir/GNUstep/Makefiles/config.sub
%_datadir/GNUstep/Makefiles/gnustep-make-help
%_man1dir/*
%_man7dir/*

%files devel
%_datadir/GNUstep/Makefiles/*.make
%_datadir/GNUstep/Makefiles/*.template
%_datadir/GNUstep/Makefiles/Instance
%_datadir/GNUstep/Makefiles/Master
%_datadir/GNUstep/Makefiles/TestFramework
%attr(755,root,root) %_datadir/GNUstep/Makefiles/install-sh
%attr(755,root,root) %_datadir/GNUstep/Makefiles/mkinstalldirs

%files doc
%_docdir/GNUstep

%changelog
