Name: gnutls28
Version: 3.3.23
Release: alt0.M70P.1

Summary: A TLS protocol implementation
# The libgnutls library is LGPLv2.1+, utilities and remaining libraries are GPLv3+
License: LGPLv2.1+ and GPLv3+
Group: System/Libraries
Url: http://gnutls.org/
# ftp://ftp.gnutls.org/pub/gnutls/gnutls-%version.tar.bz2
Source: gnutls-%version.tar

%define libcxx libgnutlsxx28
%define libssl libgnutls27-openssl
%def_disable libssl
%def_disable guile
#set_automake_version 1.11

# Skip test-hash-large for overridden CPU flags
Patch1: gnutls-patch-test-hash-large.patch

# Automatically added by buildreq on Thu Dec 08 2011
BuildRequires: gcc-c++ gtk-doc libgcrypt-devel libp11-kit-devel libreadline-devel libtasn1-devel makeinfo zlib-devel
BuildRequires: libnettle-devel autogen
%if_enabled guile
BuildRequires: guile-devel
%endif

%description
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

%package -n lib%name
Summary: Transport Layer Security library
License: LGPLv2.1+
Group: System/Libraries

%description -n lib%name
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS runtime library.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %version-%release
Conflicts: libgnutls-devel < %version-%release

%description -n lib%name-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build GnuTLS-based software.

%package -n %libcxx
Summary: Transport Layer Security C++ library
Group: System/Libraries
License: GPLv3+
Requires: lib%name = %version-%release

%description -n %libcxx
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS C++ runtime library.

%package -n %libcxx-devel
Summary: Development files for libgnutlsxx
Group: Development/C++
Requires: %libcxx = %version-%release
Requires: lib%name-devel = %version-%release
Conflicts: libgnutlsxx-devel < %version-%release

%description -n %libcxx-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build GnuTLS-based software using C++.

%package -n %libssl
Summary: OpenSSL compatibility layer for the GnuTLS library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n %libssl
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS runtime OpenSSL compatibility library.

%package -n %libssl-devel
Summary: Development files for %libssl
Group: Development/C
Requires: %libssl = %version-%release
Requires: lib%name-devel = %version-%release
Conflicts: libgnutls-openssl-devel < %version-%release

%description -n %libssl-devel
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains headers and other development files required to
build applications using the GnuTLS compatibility OpenSSL library.

%package utils
Summary: TLS protocol utilities
Group: Security/Networking
Conflicts: gnutls-utils26

%description utils
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains command line TLS client and server, and
certificate manipulation tools.

%package -n lib%name-guile
Summary: GnuTLS Guile bindings
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-guile
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains Guile bindings for the library.

%package devel-doc
Summary: Development documentation for GnuTLS
Group: Development/C
Conflicts: libgnutls-devel < %version
BuildArch: noarch

%description devel-doc
GnuTLS is a project that aims to develop a library which provides a
secure  layer, over a reliable transport layer.  Currently the GnuTLS
library implements the proposed standards by the IETF's TLS working
group.

This package contains the GnuTLS API Reference Manual.

%prep
%setup -n gnutls-%version
touch doc/*.texi
rm doc/*.info*
%patch1 -p2
rm aclocal.m4 m4/{libtool,lt*}.m4
# Thanks to USE_POSIX_THREADS_WEAK feature, we have to link
# tests with @LIBMULTITHREAD@ in --no-as-needed mode.
sed -i 's/^\(test_[^ +=]\+\)_LDADD.*@LIBMULTITHREAD@.*/&\n\1_LDFLAGS = -Wl,--no-as-needed/' gl/tests/Makefile.*
# Hope automake version 1.11.6 is enough.
sed -i 's/^AM_INIT_AUTOMAKE(\[1\.12\.2/AM_INIT_AUTOMAKE([1.11.6/' configure.ac

%build
%autoreconf
%def_disable static
%configure \
	--disable-rpath \
	--disable-static \
	--disable-silent-rules \
	--disable-libdane  \
	--without-tpm \
	--with-default-trust-store-file=/usr/share/ca-certificates/ca-bundle.crt \
	%{subst_enable guile} \
	%{?_disable_libssl:--disable-openssl-compatibility} \
	--enable-local-libopts \
	--with-included-libtasn1=no
make MAKEINFOFLAGS=--no-split

%install
%makeinstall_std
find %buildroot%_infodir/ -name '*.png' -delete -print
%define docdir %_docdir/gnutls-%version
mkdir -p %buildroot%docdir/{examples,reference}
install -p -m644 AUTHORS NEWS README THANKS %buildroot%docdir/
install -p -m644 doc/*.{cfg,css,html,png} %buildroot%docdir/
install -pm644 doc/examples/*.[hc]* %buildroot%docdir/examples/
install -pm644 doc/reference/html/* %buildroot%docdir/reference/
ln -s %_licensedir/GPL-2 %buildroot%docdir/COPYING
ln -s %_licensedir/LGPL-2.1 %buildroot%docdir/COPYING.LIB

%find_lang gnutls
%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
%make_build -k check

%files -n lib%name -f gnutls.lang
%dir %docdir
%docdir/[ACNRT]*
%_libdir/libgnutls.so.*

%files -n %libcxx
%_libdir/libgnutlsxx.so.*

%if_enabled libssl
%files -n %libssl
%_libdir/libgnutls-openssl.so.*
%endif

%files -n lib%name-devel
%_includedir/gnutls/
%exclude %_includedir/gnutls/gnutlsxx.h
%{?_enable_libssl:%exclude %_includedir/gnutls/openssl.h}
%_libdir/libgnutls.so
%_pkgconfigdir/gnutls.pc

%files -n %libcxx-devel
%dir %_includedir/gnutls/
%_includedir/gnutls/gnutlsxx.h
%_libdir/libgnutlsxx.so


%if_enabled libssl
%files -n %libssl-devel
%dir %_includedir/gnutls/
%_includedir/gnutls/openssl.h
%_libdir/libgnutls-openssl.so
%endif

%files devel-doc
%dir %docdir
%docdir/*.css
%docdir/*.html
%docdir/*.png
%docdir/examples/
%docdir/reference/
%_man3dir/*
%_infodir/*

%files utils
%_bindir/*
%_man1dir/*
%dir %docdir
%docdir/*.cfg

%if_enabled guile
# %%_datadir/guile belongs to guile package
# %%_datadir/guile/site may contain not only gnutls guile files.
# therefore %%_datadir/guile and %%_datadir/guile/site are not packaged. 
# is there some package using 'site' directory?
%files -n lib%name-guile
%_libdir/libguile*
%_datadir/guile/site/gnutls
%_datadir/guile/site/gnutls.scm
%endif

%changelog
