%define ver_major 1.36

Name: gobject-introspection
Version: %ver_major.0
Release: alt1

Summary: Introspection system for GObject-based libraries
Group: Development/C
License: GPLv2+, LGPLv2+, MIT
URL: https://live.gnome.org/GObjectIntrospection

Provides: gir-repository = %version-%release
Obsoletes: gir-repository

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildPreReq: libgio-devel >= 2.36.0
BuildRequires: flex gtk-doc libcairo-devel libcairo-gobject-devel libffi-devel libgio-devel
BuildRequires: python-devel python-modules-ctypes python-modules-compiler rpm-build-gir

%description
GObject Introspection can scan C header and source files in order to
generate introspection "typelib" files.  It also provides an API to examine
typelib files, useful for creating language bindings among other
things.

%package devel
Summary: Libraries and headers for gobject-introspection
Group: Development/C
Requires: %name = %version-%release libgio-devel rpm-build-gir
Provides: gir-repository-devel = %version-%release
Obsoletes: gir-repository-devel

%description devel
Libraries and headers for gobject-introspection

%package devel-doc
Summary: Documentation for gobject-introspection
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides development documentation for gobject-introspection

%prep
%setup -q

%build
%autoreconf
%configure \
	--disable-static \
	--enable-gtk-doc
%make

%check
%make check

%install
%make DESTDIR=%buildroot install

find %buildroot%_libdir -name \*.la -delete

%files
%_libdir/lib*.so.*
%_libdir/girepository-1.0

%files devel
%_includedir/%name-1.0
%_bindir/g-ir-*
%_libdir/lib*.so
%dir %_libdir/%name
%_libdir/%name/giscanner/
%_pkgconfigdir/*.pc
%_datadir/gir-1.0
%_datadir/%name-1.0
%_datadir/aclocal/*.m4
%_man1dir/*.1*

%files devel-doc
%_datadir/gtk-doc/html/*

%changelog
