%define _unpackaged_files_terminate_build 1
Release: alt7.git
Version: 1.0.1

Name: goldendict

Summary: Feature-rich dictionary lookup program
License: GPLv3
Group: Education
URL: http://www.goldendict.org

Source0: %name-%version.tar.bz2
Patch0: %name-post-%version.patch.bz2
Patch1: %name-%version-alt-changes-%release.patch
BuildRequires(pre): libqt4-devel libXtst-devel bzlib-devel

# Automatically added by buildreq on Fri Apr 03 2009
BuildRequires: gcc-c++ libX11-devel libqt4-devel >= 4.5.0 libvorbis-devel libzip-devel libhunspell-devel
BuildRequires: phonon-devel
BuildRequires: xorg-recordproto-devel
Requires: libqt4-core

%description
GoldenDict is feature-rich dictionary lookup program. Features:
* Use of WebKit for an accurate articles' representation, complete with
  all formatting, colors, images and links.
* Support of multiple dictionary file formats, namely:
  - Babylon .BGL files, complete with images and resources
  - StarDict .ifo/.dict./.idx/.syn dictionaries
  - Dictd .index/.dict(.dz) dictionary files
  - ABBYY Lingvo .dsl source files, together with abbreviations. The
    files can be optionally compressed with dictzip. Dictionary
    resources can be packed together into a .zip file.
  - ABBYY Lingvo .lsa/.dat audio archives. Those can be indexed
    separately, or be referred to from .dsl files.
* Support for Wikipedia, Wiktionary, or any other MediaWiki-based sites
  to perform lookups in.
* Ability to use arbitrary websites as dictionaries via templated Url
  patterns.
* Support for looking up and listening to pronunciations from forvo.com
* Hunspell-based morphology system, used for word stemming and spelling
  suggestions.
* Ability to index arbitrary directories with audio files for
  pronunciation lookups.
* Full Unicode case, diacritics, punctuation and whitespace folding.
  This means the ability to type in words without any accents, correct
  case, punctuation or spaces.
* Scan popup functionality. A small window pops up with the translation
  of a word chosen from another application.
* Support for global hotkeys. You can spawn the program window at any
  point, or directly translate a word from the clipboard.
* Tabbed browsing in a modern Qt 4 interface.
%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
# Our phonon headers are located in a KDE4-specific directory
PREFIX=%_prefix /usr/bin/qmake-qt4 QMAKE_LRELEASE=%_qt4dir/bin/lrelease 'INCLUDEPATH+=%_includedir/kde4/KDE'
%make

%install
# we need to re-create Makefile, because qmake doesn't generate custom
# targets' install rules if these targets files are missing when qmake
# runs. So translations files (being generated during make) aren't
# installed by default. The problem is described in
# http://ananasplanet.ning.com/profiles/blogs/o-strannom-povedenii-qmake-pri
PREFIX=%_prefix /usr/bin/qmake-qt4 QMAKE_LRELEASE=%_qt4dir/bin/lrelease 'INCLUDEPATH+=%_includedir/kde4/KDE'
%make_install INSTALL_ROOT=%buildroot install

# our find-lang.sh doesn't recognize .qm translation files
#find_lang --with-qt goldendict
find %buildroot%_datadir -name '*.qm' -print \
	| sed -e 's,%buildroot,,' -e 's,^\(.*\)/\([^/]*\)\.qm$,%%lang(\2) \1/\2.qm,' \
	> goldendict.lang

rm -rf %buildroot%_datadir/app-install

%files -f goldendict.lang
%_bindir/*
%attr(0644, root, root) %_datadir/applications/*.desktop
%_pixmapsdir/*
%dir %_datadir/%name
%dir %_datadir/%name/locale

%changelog
