Name: gosa
Version: 2.6.11
Release: alt1

Summary: Web Based LDAP Administration Program
License: GPL
Group: Networking/WWW

Url: http://gosa.gonicus.de
BuildArch: noarch

Source0: gosa-core-%version.tar
Source1: gosa-plugins-%version.tar
Source2: %name.apache.conf
Source3: gosa-core.schema
Source4: gosa-schemas-fds.tar

BuildRequires(pre): rpm-macros-webserver-common
BuildRequires: rsync

Requires:  %name-common = %version-%release, %name-php, %name-httpd

%description
GOsa is a combination of system-administrator and end-user web
interface, designed to handle LDAP based setups.
Provided is access to posix, shadow, samba, proxy, fax, and kerberos
accounts. It is able to manage the postfix/cyrus server combination
and can write user adapted sieve scripts.

%package common
Group: Networking/WWW
Summary: gosa common stuff
Requires: fping smbldap-tools perl-Crypt-SmbHash gettext-tools
Requires: /usr/bin/convert

%description common
%summary

%package apache
Group: Networking/WWW
Summary: apache1 configs for gosa
Requires: %name-common = %version-%release, apache
Provides: gosa-httpd

%description apache
%summary

%package apache2
Group: Networking/WWW
Summary: apache2 configs for gosa
Requires: %name-common = %version-%release, apache2
Provides: gosa-httpd

%description apache2
%summary

%package php5
Group: Networking/WWW
Summary: package for install all php dependencies for gosa (php5)
Requires: %name-common = %version-%release
Requires: php-engine php5-ldap php5-imap php5-mysql php5-gd2
Requires: php5-mbstring php5-libs php5-mhash php5-snmp
#Requires: php5-imagick
Provides: gosa-php

%description php5
%summary

%package schema
Group: Networking/WWW
Summary: Schema Definitions for the GOSA package
Requires: openldap-servers openldap-clients

%description schema
Contains the Schema definition files for the GOSA admin package.

%package fds-schema
Group: Networking/WWW
Summary: Schema Definitions for the GOSA package (Fedora Directory Server)
Requires: fedora-ds

%description fds-schema
Contains the Schema definition files for the GOSA admin package (Fedora
Directory Server).

%package user-manual-en
Group: Networking/WWW
Summary: English online user-manual for GOSA package
Requires: %name-common = %version-%release

%description user-manual-en
English online user-manual page for GOSA package

%add_findreq_skiplist %_datadir/%name/plugins/mail/contrib/*
%add_findreq_skiplist %_datadir/%name/plugins/nagios/contrib/*
%add_findreq_skiplist %_datadir/%name/plugins/samba/contrib/*
%add_findreq_skiplist %_datadir/%name/plugins/squid/contrib/*

%prep
%setup -n gosa-core-%version -a 1 -a 4
# apply RH patches included in distribution
patch -p1 < redhat/02_fix_class_mapping.patch
patch -p1 < redhat/03_fix_locale_location.patch
patch -p1 < redhat/04_fix_online_help_location.patch

%install
install -dm1770 %buildroot%_var/spool/%name
install -d %buildroot%_var/cache/%name
install -dm0750 %buildroot%_sysconfdir/%name/

# Cleanup lyx warnings
find . -name WARNINGS -delete

# Cleanup latex shit
find . -name labels.pl -delete

# Cleanup guide
rm -rf doc/core/*/lyx-source

# php
mkdir -p %buildroot%_datadir/%name
DIRS="ihtml plugins html include locale setup"
for i in $DIRS; do
	cp -r $i %buildroot%_datadir/%name
done
install -d %buildroot%_datadir/%name/doc/core/
cp -r doc/core/en %buildroot%_datadir/%name/doc/core/

# binary
install -d %buildroot%_bindir/
install -pDm0755 update-gosa %buildroot%_sbindir/update-gosa
install -pDm0755 bin/mkntpasswd %buildroot%_bindir/
install -pDm0755 bin/gosa-encrypt-passwords %buildroot%_bindir/

# contrib
install -pD -m0644 contrib/gosa.conf %buildroot%_datadir/%name/doc/gosa.conf
install -pD -m0644 contrib/shells %buildroot%_sysconfdir/%name/
install -pD -m0644 contrib/encodings %buildroot%_sysconfdir/%name/
install -pD -m0644 contrib/openldap/slapd.conf %buildroot%_defaultdocdir/%name-common-%version/slapd.conf-example

# schemas
install -dm0755 %buildroot%_sysconfdir/openldap/schema/%name
mv contrib/openldap/*.schema %buildroot%_sysconfdir/openldap/schema/%name

# manpages
install -pDm0644 update-%name.1 %buildroot%_man1dir/update-%name.1
install -pDm0644 gosa-encrypt-passwords.1 %buildroot%_man1dir/gosa-encrypt-passwords.1
install -pDm0644 contrib/%name.1 %buildroot%_man1dir/%name.1
install -pDm0644 contrib/%name.conf.5 %buildroot%_man5dir/%name.conf.5

# configs
touch %buildroot%_sysconfdir/%name/gosa.secrets
install -p doc/core/guide.xml %buildroot%_sysconfdir/%name/guide.xml

install -pD -m0644 %SOURCE2 %buildroot%_sysconfdir/httpd/conf/addon-modules.d/%name.conf
install -pD -m0644 %SOURCE2 %buildroot%_sysconfdir/httpd2/conf/addon.d/%name.conf

install -dm0755 %buildroot%_datadir/%name/fedora-ds/schema/
mv gosa-schemas-fds/*.ldif %buildroot%_datadir/%name/fedora-ds/schema/

# plugins
pushd gosa-plugins
for plugin in *; do
	if [ `stat -c%%h $plugin/html` -gt 2 ] 2>/dev/null; then
		install -d %buildroot%_datadir/%name/html/plugins/$plugin
		mv $plugin/html/* %buildroot%_datadir/%name/html/plugins/$plugin/
	fi
	if [ `stat -c%%h $plugin/contrib` -gt 2 ] 2>/dev/null; then
		install -d %buildroot%_defaultdocdir/%name-common-%version/plugins/$plugin/
		mv $plugin/contrib/* %buildroot%_defaultdocdir/%name-common-%version/plugins/$plugin/
	fi
	if [ `stat -c%%h $plugin/help` -gt 2 ] 2>/dev/null; then
		install -d %buildroot%_datadir/%name/doc/plugins/$plugin
		mv $plugin/help/* %buildroot%_datadir/%name/doc/plugins/$plugin/
	fi
	if [ `stat -c%%h $plugin/etc` -gt 2 ] 2>/dev/null; then
		mv $plugin/etc/* %buildroot%_sysconfdir/%name/
	fi
	if [ `stat -c%%h $plugin/locale` -gt 2 ] 2>/dev/null; then
		install -d %buildroot%_datadir/%name/locale/plugins/$plugin
		mv $plugin/locale/* %buildroot%_datadir/%name/locale/plugins/$plugin/
	fi
	for s in addons admin generic personal; do
		if [ -d $plugin/$s ]; then
			rsync -rt $plugin/$s %buildroot%_datadir/%name/plugins/
		fi
	done
done
popd

%post apache
/sbin/service httpd condreload

%postun apache
/sbin/service httpd condreload

%post apache2
/sbin/service httpd2 condreload

%postun apache2
/sbin/service httpd2 condreload

%post common
%_sbindir/update-gosa ||:

%files

%files common
%doc AUTHORS README* Changelog COPYING INSTALL FAQ
%_mandir/man?/*
%dir %_datadir/%name
%dir %_datadir/%name/doc
%_datadir/%name/html
%_datadir/%name/ihtml
%_datadir/%name/include
%_datadir/%name/locale
%_datadir/%name/plugins
%_datadir/%name/setup
%_bindir/*
%_sbindir/*
%dir %attr(1770,root,%webserver_group) %_spooldir/%name
%dir %attr(1770,root,%webserver_group) %_var/cache/%name
%dir %attr(0750,root,%webserver_group) %_sysconfdir/%name
%_sysconfdir/%name/*
%dir %_datadir/%name/doc/core
%_datadir/%name/doc/gosa.conf
%_datadir/%name/doc/plugins

%files apache
%config(noreplace) %_sysconfdir/httpd/conf/addon-modules.d/%name.conf

%files apache2
%config(noreplace) %_sysconfdir/httpd2/conf/addon.d/%name.conf

%files php5

%files schema
%dir %_sysconfdir/openldap/schema/%name
%_sysconfdir/openldap/schema/%name/*

%files fds-schema
%_datadir/%name/fedora-ds/schema/*.ldif

%files user-manual-en
%_datadir/%name/doc/core/en

%changelog
