%def_with pic

%define Name GParted
Name: gparted
Version: 0.8.0
Release: alt1.1
Summary: %Name Partition Editor
Summary(ru_RU.CP1251):   %Name
Summary(uk_UA.CP1251):   %Name
License: %gpl2plus
Group: System/Configuration/Hardware
URL: http://%name.sourceforge.net/
Source0: %name-%version.tar
#http://prdownloads.sourceforge.net/%name/%name-%version.tar.bz2?download
Source1: %name-pam
Source2: %name-security
Patch0: %name-%version-%release.patch
Patch1: %name-0.8.0-alt-DSO.patch
#Patch1: %name-%version-led.patch
Packager: Led <led@altlinux.ru>
AutoReq: yes, noshell

BuildRequires(pre): rpm-build-licenses
BuildRequires: libparted-devel >= 1.7.1
BuildRequires: libgtkmm2-devel >= 2.8
BuildRequires: gcc-c++ libprogsreiserfs-devel libuuid-devel intltool
BuildRequires: perl-XML-Parser gnome-doc-utils librarian

%description
%Name stands for %Name Partition Editor. It uses libparted to detect
and manipulate devices and partitiontables while several (optional)
filesystemtools provide support for filesystems not included in
libparted. These optional packages will be detected at runtime and
don't require a rebuild of %Name.
%Name is written in C++ and uses gtkmm as Graphical Toolkit. The
general approach is to keep the GUI as simple as possible.

%description -l ru_RU.CP1251
%Name - %Name Partition Editor.   libparted 
       ,  
 ()  (   libparted),
   .   
        %Name.
%Name   C++   gtkmm   
.   -  GUI  .

%description -l uk_UA.CP1251
%Name - %Name Partition Editor. ³  libparted 
       ,  
 (')  (   libparted), 
   . ֳ ' 
        %Name.
%Name   C++   gtkmm   
.   -  GUI  .


%prep
%setup
%patch0 -p1
%patch1 -p0


%build
%define _optlevel s
%autoreconf
%configure %{subst_with pic} --bindir=%_sbindir
%make_build
bzip2 --best --keep --force ChangeLog


%install
%make_install DESTDIR=%buildroot install

# usermode
install -pD -m640 %SOURCE1 %buildroot%_sysconfdir/pam.d/%name
install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/security/console.apps/%name
install -d -m 0755 %buildroot%_bindir
ln -s %_bindir/consolehelper %buildroot%_bindir/%name

%find_lang --with-gnome %name


%files -f %name.lang
%doc AUTHORS ChangeLog.* README
%_sbindir/*
%_bindir/*
%_man8dir/*
%_sysconfdir/pam.d/*
%_sysconfdir/security/console.apps/*
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*


%changelog
