Name: gpgme
Version: 1.4.4
Release: alt0.M70P.1

%define min_gnupg_version 1.9.6

Summary: GnuPG Made Easy is a library designed to make access to GnuPG easier for applications
License: LGPLv2.1+
Group: System/Libraries
Url: http://www.gnupg.org/related_software/gpgme/index.html

# ftp://ftp.gnupg.org/gcrypt/gpgme/gpgme-%version.tar.bz2
Source: gpgme-%version.tar

Patch1: gpgme-1.4.3-alt-version-script.patch
Patch2: gpgme-1.3.0-alt-gpgme-config-assuan.patch
Patch3: gpgme-1.3.0-alt-tests.patch
Patch4: gpgme-1.3.2-rh-alt-linkage.patch

Requires: gnupg2-gpg >= %min_gnupg_version

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildRequires: /proc gcc-c++ gnupg2 libgpg-error-devel libpth-devel libstdc++-devel libassuan-devel >= 2.0

%package -n lib%name
Summary: GnuPG Made Easy!
Group: System/Libraries
Requires: gnupg2-gpg >= %min_gnupg_version
Provides: libgpgme1 = %version-%release
Obsoletes: libgpgme1 < %version-%release

%package -n lib%name-devel
Summary: Include files for development with GPGME
Group: Development/C
Requires: lib%name = %version-%release
Requires: libgpg-error-devel
Provides: libgpgme1-devel = %version-%release
Obsoletes: libgpgme1-devel < %version-%release

%package -n lib%name-devel-static
Summary: Static libraries for development with GPGME
Group: Development/C
Requires: lib%name-devel = %version-%release
Provides: libgpgme1-devel-static = %version-%release
Obsoletes: libgpgme1-devel-static < %version-%release

%description
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

%description -n lib%name
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

%description -n lib%name-devel
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

This package contains include files required for development of
GPGME-based applications.

%description -n lib%name-devel-static
GnuPG Made Easy (GPGME) is a C language library that allows to add
support for cryptography to a program.  It is designed to make access
to public key crypto engines like GnuPG or GpgSM easier for
applications.  GPGME provides a high-level crypto API for encryption,
decryption, signing, signature verification and key management.

This package contains static libraries required for development of
GPGME-based statically linked applications.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

rm doc/*.info* m4/{libtool,lt}*.m4

%build
%autoreconf
mkdir -p tmp_bin
ln -sf %_bindir/gpg2 tmp_bin/gpg
export PATH=$PWD/tmp_bin:$PATH

%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
# --enable-maintainer-mode is required to generate the info file
# when building from CVS snapshot
%configure \
	%{?cvsdate: --enable-maintainer-mode } \
	%{subst_enable static} \
	--with-gpg=%_bindir/gpg2 \
	--with-gpgsm=%_bindir/gpgsm

%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std

%check
%make_build -k check

%files -n lib%name
%_libdir/*.so.*
%doc AUTHORS NEWS README THANKS

%files -n lib%name-devel
%_bindir/*
%_includedir/*.h
%_libdir/*.so
%_datadir/aclocal/*.m4
%_infodir/*.info*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
