Name: gpsd
Summary: Service daemon for mediating access to a GPS
Version: 2.94
Release: alt2.1
License: BSD
Group: System/Servers
Url: http://developer.berlios.de/projects/gpsd/
Packager: Anton V. Boyarshinov <boyarsh@altlinux.ru>

Source: %name-%version.tar
Requires: libgps = %version-%release
# Automatically added by buildreq on Tue Sep 27 2011
# optimized out: glib2-devel libICE-devel libSM-devel libX11-devel libXmu-devel libXt-devel libdbus-devel libdbus-glib libgpg-error libncurses-devel libstdc++-devel libtinfo-devel python-base python-modules xml-common xorg-xproto-devel
BuildRequires: docbook-dtds docbook-style-xsl gcc-c++ imake libXaw-devel libXext-devel libXpm-devel libdbus-glib-devel python-devel xorg-cf-files xsltproc

%description
gpsd is a service daemon that mediates access to a GPS sensor
connected to the host computer by serial or USB interface, making its
data on the location/course/velocity of the sensor available to be
queried on TCP port 2947 of the host computer.  With gpsd, multiple
GPS client applications (such as navigational and wardriving software)
can share access to a GPS without contention or loss of data.  Also,
gpsd responds to queries with a format that is substantially easier to
parse than NMEA 0183.  A client library is provided for applications.

After installing this RPM, gpsd will automatically connect to USB
GPSes when they are plugged in and requires no configuration.  For
serial GPSes, you will need to start gpsd by hand.  Once connected,
the daemon automatically discovers the correct baudrate, stop bits,
and protocol. The daemon will be quiescent when there are no
clients asking for location information, and copes gracefully when the
GPS is unplugged and replugged.

%package -n libgps
Summary: Client libraries in C and Python for talking to a running gpsd or GPS
Group: Sciences/Geosciences
Requires: gpsd
%description -n libgps
Client libraries in C and Python for talking to a running gpsd or GPS

%package -n libgps-devel
Summary: Development files for libgps
Group: Development/C
Requires: libgps = %version-%release

%description -n libgps-devel
Development files for libgps

%package -n gpsd-clients
Summary: Clients for gpsd with an X interface
Group: Sciences/Geosciences
Requires: libgps = %version-%release

%description -n gpsd-clients
xgpsspeed is a speedometer that uses position information from the GPS.
It accepts an -h option and optional argument as for gps, or a -v option
to dump the package version and exit. Additionally, it accepts -rv
(reverse video) and -nc (needle color) options.

cgps resembles xgps, but without the pictorial satellite display.  It
can run on a serial terminal or terminal emulator.
%prep
%setup

%build
%autoreconf
%configure --enable-dbus

%make_build
%make xgps xgpsspeed

%install
%makeinstall
# additional gpsd files
mkdir -p %buildroot%_libdir/X11/app-defaults/
cp xgpsspeed.ad %buildroot%_libdir/X11/app-defaults/xgpsspeed
mkdir -p %buildroot%_sysconfdir/hotplug/usb
cp gpsd.hotplug gpsd.usermap %buildroot%_sysconfdir/hotplug/usb/

%files
%doc README INSTALL COPYING
%_bindir/gpsctl
%_sbindir/gpsd
%_man1dir/gpsctl.*
%_man8dir/gpsd.*
%_man5dir/*
%_sysconfdir/hotplug/usb/gpsd.hotplug
%_sysconfdir/hotplug/usb/gpsd.usermap

%files -n libgps
%_libdir/libgps*.so.*

%files -n libgps-devel
%_libdir/libgps*.so
%_pkgconfigdir/*.pc
%_includedir/*.h
%_man3dir/*

%files -n gpsd-clients
%_bindir/*
%exclude %_bindir/gpsctl
%_man1dir/*
%exclude %_man1dir/gpsctl.*
%_libdir/X11/app-defaults/xgpsspeed

%changelog
