%def_with netcdf
%def_without pdflib

Name: grace
Version: 5.1.22
Release: alt9.3

Summary: WYSIWYG tool to make two-dimensional plots of scientific data
License: GPL
Group: Sciences/Mathematics

Url: http://plasma-gate.weizmann.ac.il/Grace/
Source: ftp://plasma-gate.weizmann.ac.il/pub/grace/src/grace5/%name-%version.tar.gz
Source4: grace.desktop
Source5: grace.xpm
Source6: grace-32.xpm
Source7: grace-set_default_enc
Patch1: grace-5.1.9-alt1-alt-makefile-bindir.patch
Patch2: grace-5.1.9-alt1-alt-makefile-install_GRACECLI.patch
Patch3: grace-5.1.9-alt1-alt-makefile-install_man.patch
Patch4: grace-5.1.9-alt1-alt-makefile-install_grace_np.patch
Patch5: grace-5.1.11-alt1-alt-makefile-font_links.patch
Patch6: grace-5.1.9-alt1-alt-config-gracerc.patch
Patch7: grace-5.1.22-alt-libpng15.patch
Packager: Michael Shigorin <mike@altlinux.org>

Requires: fonts-type1-urw >= 1.0.7
Requires: url_handler >= 0.2.1

BuildPreReq: libXext-devel

# Automatically added by buildreq on Wed Jun 03 2009
BuildRequires: imake libXbae-devel libXmu-devel libXp-devel libXpm-devel libfftw-devel libjpeg-devel libopenmotif-devel libpng-devel t1lib-devel xorg-cf-files libX11-devel libSM-devel

%{?_with_pdflib:BuildRequires: libpdflib-lite-devel}
# argh
%{?_with_netcdf:BuildRequires: libnetcdf-devel}
%{?_with_netcdf:Requires: libnetcdf7 libhdf5-7}
# no need this conflict now
#{?_with_netcdf:Conflicts: libnetcdf6-mpi libhdf5-6-mpi mpi-selector openmpi}

Summary(ru_RU.KOI8-R): WYSIWYG-    

%description
Grace is a tool to make two-dimensional plots of numerical data. It runs
under various (if not all) flavours of UNIX with X11 and M*tif. Its
capabilities are roughly similar to GUI-based programs like Sigmaplot or
Microcal Origin plus script-based tools like gnuplot or Genplot. Its
strength lies in the fact that it combines the convenience of a
graphical user interface with the power of a scripting language which
enables it to do sophisticated calculations or perform automated tasks.

%description -l ru_RU.KOI8-R
Grace --        
.     (   )  UNIX,
  X11  M*tif.     
,  Sigmaplot  Microcal Origin, ,    
  ,  gnuplot  Genplot.   
   ,       
     ,  
      .

%package devel
Summary: A library for interfacing with Grace using pipes
Summary(ru_RU.KOI8-R):     Grace   (pipes)
Group: Development/C
Requires: %name = %version-%release

%description devel
A library for interfacing with Grace using pipes

%description -l ru_RU.KOI8-R devel
    Grace   (pipes)

%prep
%setup -n %name-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p2
cp -a %SOURCE7 set_default_enc

%build
%add_optflags -I%_includedir/netcdf-3
%configure \
	--prefix=%_datadir \
        --with-bundled-xbae=no \
	%{subst_enable netcdf} \
	--enable-xmhtml=no \
	--with-helpviewer="url_handler.sh %%s" \
	--enable-grace-home=%_datadir/grace
%make_build

%install
%makeinstall DESTDIR=%buildroot

install -m 755 set_default_enc %buildroot%_datadir/grace/auxiliary/
ln -s ../doc/%name-%version/doc %buildroot%_datadir/grace/doc
ln -s KOI8-R.enc %buildroot%_datadir/grace/fonts/enc/Default.enc

install -pDm644 %SOURCE4 %buildroot%_desktopdir/%name.desktop
install -pDm644 %SOURCE5 %buildroot%_miconsdir/%name.xpm
install -pDm644 %SOURCE6 %buildroot%_niconsdir/%name.xpm
install -pDm644 %SOURCE6 %buildroot%_liconsdir/%name.xpm

%post
GRACE_HOME=%_datadir/grace %_datadir/grace/auxiliary/set_default_enc

%triggerpostun -- grace < 5.1.9-alt2
GRACE_HOME=%_datadir/grace %_datadir/grace/auxiliary/set_default_enc

%files
%_bindir/*
%dir %_datadir/grace
%_datadir/grace/*
%_man1dir/*
%_desktopdir/*
%_niconsdir/*.xpm
%_miconsdir/*.xpm
%_liconsdir/*.xpm
%doc doc CHANGES COPYRIGHT LICENSE src/XMgrace.ad

%files devel
%dir %_libdir/grace
%dir %_includedir/grace
%_libdir/grace/*
%_includedir/grace/*

# TODO:
# - build with XmHTML, PDFlib (which are currently orphaned)
# - look into printing support

%changelog
