# help is welcome to re-enable, fix packaging and test
%def_enable  guile
%def_disable lua
%def_disable ocaml
%def_disable php
%def_disable python
%def_disable ruby

Name: graphviz
Version: 2.28.0
Release: alt4

Summary: Graphs visualization tools
License: Common Public License 1.0
Group: Publishing

# Git: http://www.graphviz.org/pub/scm/graphviz2/.git
Url: http://www.graphviz.org
Source0: %name-%version.tar
Source1: graphviz-2.2-alt-libpath.patch
Patch0:  graphviz-2.24.0-alt-perl-5.12.patch
Patch1:  graphviz-2.28.0-alt-string_h_trhow.patch
Packager: Michael Shigorin <mike@altlinux.org>

Requires: lib%name = %version-%release
Provides: libdotneato = %version
Obsoletes: libdotneato < %version

# Automatically added by buildreq on Wed Oct 12 2011 (-bi)
BuildRequires: flex gcc-c++ ghostscript-utils groff-base guile18-devel imake libXaw-devel libXpm-devel libexpat-devel libfreeglut-devel libgd2-devel libglade-devel libgs-devel libgtkglext-devel libgts-devel liblasi-devel libpng-devel librsvg-devel swig tk-devel xorg-cf-files

%{?_enable_lua:BuildRequires: liblua5-devel}
%{?_enable_guile:BuildRequires: guile18-devel}

%define gvlibdir %_libdir/%name
%define gvdatadir %_datadir/%name

%set_verify_elf_method unresolved=relaxed
%add_findreq_skiplist %gvdatadir/demo/*.pl
%add_findreq_skiplist %gvdatadir/demo/*.tcl

%description
Graphviz is a set of graph drawing tools originally developed
at AT&T Research.

Graph drawing addresses the problem of visualizing structural
information by constructing geometric representations of abstract
graphs and networks.  Automatic generation of graph drawings has
important applications in key technologies such as database
design, software engineering, VLSI and network design and visual
interfaces in other domains.

# {{{ subpackages
%package -n lib%name
Summary: Shared libraries for %name
Group: System/Libraries

%description -n lib%name
This package includes shared libraries for %name

%package -n lib%name-devel
Summary: Header files and C programming manual for %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%name-devel
This package includes header files for %name

%package doc
Summary: Documentation for %name
Group: Publishing
Requires: %name = %version-%release
BuildArch: noarch

%description doc
This package contains most of documentation for %name

%package graphs
Summary: Demo graphs for graphviz
Group: Graphics
Requires: %name = %version-%release
BuildArch: noarch

%description graphs
This package provides some example graphs for %name.

%if_enabled guile
%package guile
Summary: Guile bindings to %name
Group: Development/Other
Requires: %name = %version-%release

%description guile
This package makes %name functionality accessible from Guile
%endif

%if_enabled lua
%package lua
Summary: Lua bindings to %name
Group: Development/Other
Requires: %name = %version-%release

%description lua
This package makes %name functionality accessible from Lua
%endif

%package perl
Summary: Perl bindings to %name
Group: Development/Perl
Requires: %name = %version-%release

%description perl
This package makes %name functionality accessible from Perl

%if_enabled python
%package python
Summary: Python bindings to %name
Group: Development/Python
Requires: %name = %version-%release

%description python
This package makes %name functionality accessible from Python
%endif

%package ruby
Summary: Ruby bindings to %name
Group: Development/Ruby
Requires: %name = %version-%release

%description ruby
This package makes %name functionality accessible from Ruby

%package tcl
Summary: Tcl bindings to %name
Group: Development/Tcl
Requires: %name = %version-%release
Requires: tcl >= 8.4.0-alt1
Provides: tcl-tkspline = %version tcl-gd = %version
Obsoletes: tcl-tkspline < %version tcl-gd < %version

%description tcl
This package makes %name functionality accessible from Tcl

# }}}

%prep
%setup
%patch0 -p1
%patch1

%build
%add_optflags -DNDEBUG %optflags_fastmath
%configure \
	--disable-static \
	--with-pangocairo \
	--with-x \
	--with-gdk-pixbuf \
	--without-gnomeui \
	--with-gtk \
	--with-ipsepcola \
	--with-sfdp \
	--with-smyrna \
	%{subst_enable guile } \
	%{subst_enable lua } \
	%{subst_enable ocaml } \
	%{subst_enable php } \
	%{subst_enable python } \
	%{subst_enable ruby } \
	--enable-tcl \
	--disable-java \
	--disable-sharp

%make_build

%install
%make_install DESTDIR=%buildroot install
# avoid %%doc, install by hand
mkdir -p %buildroot%_defaultdocdir
mv %buildroot%gvdatadir/doc %buildroot%_defaultdocdir/%name-%version
cp -a AUTHORS COPYING cpl1.0.txt ChangeLog NEWS %buildroot%_defaultdocdir/%name-%version
mkdir -p %buildroot%_tcldatadir/{%name,gd,tkspline}
cat <<EOF > %buildroot%_tcldatadir/gd/pkgIndex.tcl
package ifneeded Gdtclft %version "load [file join \$dir .. .. .. lib tcl libgdtclft.so.0] Gdtclft"
EOF
cat <<EOF > %buildroot%_tcldatadir/%name/pkgIndex.tcl
package ifneeded Tcldot %version "load [file join \$dir .. .. .. lib tcl libtcldot.so.0] Tcldot"
package ifneeded Tclpathplan %version "load [file join \$dir .. .. .. lib tcl libtclplan.so.0] Tclpathplan"
EOF
cat <<EOF > %buildroot%_tcldatadir/tkspline/pkgIndex.tcl
package ifneeded Tkspline %version "
	package require Tk 8.3
        load [file join \$dir .. .. .. lib tcl libtkspline.so.0] Tkspline"
EOF
# created by %_bindir/dot -c
touch %buildroot%gvlibdir/config

rm -f %buildroot%gvlibdir/*/lib*.la
rm -f %buildroot%gvlibdir/libgvplugin_*.la

%post
[ ! -x %_bindir/dot ] || %_bindir/dot -c >&/dev/null

%files
%_bindir/*
%dir %gvdatadir/
%gvdatadir/lefty
%gvdatadir/smyrna
%ghost %gvlibdir/config
%_man1dir/*
%_man7dir/*
%dir %_defaultdocdir/%name-%version/
%_defaultdocdir/%name-%version/AUTHORS
%_defaultdocdir/%name-%version/COPYING
%_defaultdocdir/%name-%version/cpl1.0.txt
%_defaultdocdir/%name-%version/ChangeLog
%_defaultdocdir/%name-%version/NEWS

%files -n lib%name
%_libdir/lib*.so.*
%dir %gvlibdir/
%gvlibdir/lib*.so.*
%gvlibdir/libgvplugin_*.so

%files -n lib%name-devel
%_includedir/%name
%_libdir/lib*.so
%_libdir/pkgconfig/*.pc
%_man3dir/*

%files doc
%_defaultdocdir/%name-%version/
%exclude %_defaultdocdir/%name-%version/AUTHORS
%exclude %_defaultdocdir/%name-%version/COPYING
%exclude %_defaultdocdir/%name-%version/cpl1.0.txt
%exclude %_defaultdocdir/%name-%version/ChangeLog
%exclude %_defaultdocdir/%name-%version/NEWS
%gvdatadir/examples

%files graphs
%gvdatadir/graphs

%if_enabled guile
%files guile
%dir %gvlibdir/guile/
%gvlibdir/guile/*.so
%endif

%if_enabled lua
%files lua
%dir %gvlibdir/lua/
%gvlibdir/lua/gv.so
%endif

%files perl
%dir %gvlibdir/perl/
%gvlibdir/perl/gv.pm
%gvlibdir/perl/gv.so
%gvlibdir/perl/libgv_perl.so
%perl_vendor_archlib/gv.pm
%perl_vendor_archlib/gv.so
%gvdatadir/demo/modgraph.pl

%if_enabled python
%files python
%dir %gvlibdir/python*/
%gvlibdir/python*/_gv.so
%endif

%if_enabled ruby
%files ruby
%dir %gvlibdir/ruby/
%gvlibdir/ruby/gv.so
%endif

%files tcl
%dir %gvlibdir/tcl/
%gvlibdir/tcl/libgdtclft.so*
%gvlibdir/tcl/libgv_tcl.so
%gvlibdir/tcl/libtcldot.so*
%gvlibdir/tcl/libtcldot_builtin.so*
%gvlibdir/tcl/libtclplan.so*
%gvlibdir/tcl/libtkspline.so*
%gvlibdir/tcl/pkgIndex.tcl
%_libdir/tcl*/*
%_tcldatadir/%name
%_tcldatadir/gd/pkgIndex.tcl
%_tcldatadir/tkspline/pkgIndex.tcl
%gvdatadir/demo/doted.tcl
%gvdatadir/demo/entities.tcl
%gvdatadir/demo/gcat.tcl
%gvdatadir/demo/modgraph.tcl
%gvdatadir/demo/pathplan.tcl
%gvdatadir/demo/spline.tcl
%gvdatadir/demo/pathplan_data
%gvdatadir/demo/*.README
%gvdatadir/demo/*.html

# TODO:
# - enable/fix/test language bindings

%changelog
