%define ver_major 0.2

Name: grilo-plugins
Version: %ver_major.9
Release: alt1
Summary: Plugins for the Grilo framework
Group: Sound
License: LGPLv2+
Url: https://live.gnome.org/Grilo

Source: %name-%version.tar

BuildRequires: gnome-common intltool >= 0.40.0
BuildRequires: gnome-doc-utils
BuildRequires: gtk-doc
BuildRequires: glib2-devel >= 2.28 libgio-devel
BuildRequires: libgrilo-devel
BuildRequires: libxml2-devel
BuildRequires: libgupnp-devel >= 0.13
BuildRequires: libgupnp-av-devel >= 0.5
BuildRequires: libgssdp-devel
BuildRequires: libsqlite3-devel
BuildRequires: libgdata-devel >= 0.7.0
BuildRequires: libquvi-devel >= 0.4.0
BuildRequires: libsoup-devel
BuildRequires: libgcrypt-devel
BuildRequires: libgmime-devel
BuildRequires: tracker-devel
BuildRequires: liboauth-devel
BuildRequires: libgnome-online-accounts-devel >= 3.7.1
BuildRequires: libtotem-pl-parser-devel >= 3.4.1
BuildRequires: libdmapsharing-devel >= 2.9.12
BuildRequires: libjson-glib-devel

Requires: grilo-tools
Requires: tracker

%description
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains plugins to get information from theses sources:
- Apple Trailers
- Bookmarks
- Filesystem
- Flickr
- Gravatar
- Jamendo
- Last.fm (for album arts)
- Local metadata (album arts and thumbnails)
- Metadata Store
- Podcasts
- Shoutcast
- Tracker
- UPnP
- Vimeo
- Youtube

%prep
%setup

%build
NOCONFIGURE=1 ./autogen.sh
%configure		\
	--disable-static \
	--disable-scrollkeeper

%make_build

%install
%make_install DESTDIR=%buildroot install

# Remove files that will not be packaged
rm -f %buildroot%_libdir/grilo-%ver_major/*.la

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS COPYING NEWS README
%_libdir/grilo-%ver_major/*.so*
%_libdir/grilo-%ver_major/*.xml

%changelog
