Name: grip
Version: 3.1.3
Release: alt14
Epoch: 20111008

Summary: an audio ripper/encoder front-end
License: GPL
Group: Sound

Url: http://www.nostatic.org/grip
Source0: %url/%name-%version.tar.gz
Source1: %name-icons.tar.bz2
Source2: %name.desktop
Source3: %name.1
Source4: %name-3.1.1-ru.po
Patch0: grip-2.99.2-ogg.patch.bz2
Patch1: grip-3.0.5-blind-write-fix.patch.bz2
#Patch2: grip-alt-i18n.patch.bz2
Patch3: grip-3.1.1-sf-rip_next_cd.patch
#Patch4: grip-3.1.1-alt-year-update.patch
Patch5: grip-3.1.2-alt-term.patch
Patch6: grip-3.1.2-alt-vte_2.1.patch
Patch7: grip-3.1.2-g_conv.patch
Patch10: grip-3.1.3-buffer.patch
Patch11: grip-3.1.3-alt-cdpath.patch
Packager: Michael Shigorin <mike@altlinux.org>

Summary(ru_RU.KOI8-R):    /  AudioCD
Summary(uk_UA.KOI8-U): Ʀ ̦  / AudioCD

%define id3lib_ver 3.8.1

Requires: id3lib >= %id3lib_ver
Requires: vorbis-tools

# Automatically added by buildreq on Thu May 15 2008
BuildRequires: gcc-c++ id3lib-devel libcdparanoia-devel libghttp-devel libgnomeui-devel libvte-devel

BuildRequires: libvte-devel >= 0.11.0-alt2
BuildRequires: libghttp-devel >= 1.0.9-alt3
# due to libid3, see src/cppmain.cc
BuildRequires: libstdc++-devel

%ifarch %ix86
BuildRequires: libcdparanoia-devel
Requires: libcdparanoia
%endif

BuildPreReq: id3lib-devel >= %id3lib_ver

# NOTE to the next maintainer, if any:
# grip-3.1.4 or so fixed compatibility with broken freedb spec
# (which is all fine in theory except that they've got loads of
# records in cp1251 marked as iso8859-1) -- so if you would like
# to update to latest version (dated 2005 as of 20090606), please
# do test it extensively and/or ask freedb folks if they have
# located and fixed such broken records; you might also want
# to package this version with dfo@'s charset conversion patch
# along with updated one.  Thanks for attention and patience.
# -- mike@

%description
Grip is a GNOME-based cd-player and cd-ripper. It has the ripping
capabilities of cdparanoia builtin, but can also use external
rippers (such as cdda2wav).
It also provides an automated frontend for MP3 encoders, letting
you take a disc and transform it easily straight into MP3s.
The CDDB protocol is supported for retrieving track information
from disc database servers.  Grip works with DigitalDJ to provide
a unified "computerized" version of your music collection.

%description -l ru_RU.KOI8-R
Grip - CD-  GNOME     
.     cdparanoia  
;       .
  CDDB.

    DigitalDJ   .

%description -l uk_UA.KOI8-U
Grip - CD-    GNOME.   
 cdparanoia  Φ ;   
 ˦ ΦΦ ˦.   Цդ
CDDB.

 ͦ   DigitalDJ  ΦƦæ æ.

%prep
%setup
%patch0 -p0 -b .tv
%patch1 -p1 -b .blind-write-fix
%patch3 -p1 -b .ripnext
%patch10 -p1 -b .buffer
%patch11 -p1 -b .cdpath

%build
export CFLAGS="$CFLAGS -g"
%configure 
%make_build

%install
%makeinstall

mkdir -p %buildroot{%_miconsdir,%_niconsdir,%_liconsdir}
tar xjf %SOURCE1 -C %buildroot%_niconsdir
mv %buildroot%_iconsdir/hicolor/32x32/apps/mini/grip.xpm \
	%buildroot%_miconsdir/
mv %buildroot%_iconsdir/hicolor/32x32/apps/large/grip.xpm \
	%buildroot%_liconsdir/

install -pDm644 %SOURCE2 %buildroot%_desktopdir/%name.desktop
install -pDm644 %SOURCE3 %buildroot%_man1dir/%name.1
install -pm644 %SOURCE4 $RPM_BUILD_DIR/%name-%version/po/

%find_lang %name-2.2

%files -f %name-2.2.lang
%doc AUTHORS CREDITS ChangeLog README TODO
%_bindir/*
%_man1dir/*
%_miconsdir/*.xpm
%_niconsdir/*.xpm
%_liconsdir/*.xpm
%_desktopdir/%name.desktop
%_datadir/pixmaps/*
%_datadir/gnome/help/%name/
%_datadir/applications/*

%changelog
