Name: grub2
Version: 2.00
Release: alt20.M70P.1

Summary: GRand Unified Bootloader
License: GPL
Group: System/Kernel and hardware

Url: http://www.gnu.org/software/grub

Source0: grub2-%version.tar
Source1: grub2-sysconfig

Source3: 39_memtest
Source4: grub2.filetrigger

Source5: grub-extras-%version.tar

Source6: grub-autoupdate

Source8: update-grub
Source9: update-grub.8

Source10: grub-efi-autoupdate

Patch0: grub-2.00-gnulib-gets.patch
Patch1: grub-2.00-os-alt.patch
Patch2: grub-2.00-sysconfig-path-alt.patch
Patch3: grub-2.00-altlinux-theme.patch
Patch4: grub-2.00-debian-uefi-os-prober.patch
Patch5: grub-2.00-os-alt-xen.patch
Patch6: grub-1.99-debian-disable_floppies.patch
Patch7: grub-2.00-grubinstall-evms-sync-alt.patch
Patch8: grub-1.99-efibootmgr-req.patch
Patch9: grub2-fix-locale-en.mo.gz-not-found-error-message.patch
Patch10: grub-2.00-r4586-one-by-off.patch
Patch11: grub-2.00-install-uefi-signed.patch
Patch12: grub2-stfu.patch
Patch13: grub-2.00-fedora-unrestricted.patch
Patch14: grub-2.00-texinfo.patch
Patch15: 0001-Fix-CVE-2015-8370-Grub2-user-pass-vulnerability.patch

Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: flex fonts-bitmap-misc fonts-ttf-dejavu libfreetype-devel python-modules ruby autogen
BuildRequires: liblzma-devel help2man zlib-devel
BuildRequires: libdevmapper-devel
BuildRequires: texinfo
BuildRequires: pesign >= 0.109-alt4
BuildRequires: rpm-macros-uefi

# fonts: choose one

## dejavu
#BuildRequires: fonts-ttf-dejavu
#define font /usr/share/fonts/ttf/dejavu/DejaVuSansMono.ttf

## terminus
#BuildRequires: fonts-bitmap-terminus
#define font /usr/share/fonts/bitmap/terminus/ter-x16n.pcf.gz

## univga
BuildRequires: fonts-bitmap-univga
%define font /usr/share/fonts/bitmap/univga/u_vga16_9.pcf.gz

## see also fonts-bitmap-ucs-miscfixed; efont-unicode doesn't fit

Exclusivearch: %ix86 x86_64

Requires: gettext

# NB: not a fashion but the critical need to fit into 62 sectors
%define _optlevel s

# build efi bootloader on some platforms only:
%if ! 0%{?efi}
%define efi %ix86 x86_64 ia64
%endif

%ifarch %ix86
%global grubefiarch i386-efi
%global grubefiname grubia32.efi
%global grubeficdname gcdia32.efi
%endif
%ifarch x86_64
%global grubefiarch x86_64-efi
%global grubefiname grubx64.efi
%global grubeficdname gcdx64.efi
%endif

# OLPC is rumoured to use IEEE1275 either
%ifarch ppc ppc64
%define platform ieee1275
%else
%define platform pc
%endif

%package common
Summary: GRand Unified Bootloader (common part)
Group: System/Kernel and hardware

%package pc
Summary: GRand Unified Bootloader (PC BIOS variant)
Group: System/Kernel and hardware
Requires: %name-common = %version-%release

Conflicts: grub
Obsoletes: grub < %version-%release

Provides: grub2 = %version-%release
Obsoletes: grub2 < %version-%release

%package efi
Summary: GRand Unified Bootloader (UEFI variant)
Group: System/Kernel and hardware
Requires: %name-common = %version-%release
%ifarch x86_64
Requires: efibootmgr
Obsoletes: %name-efi-unsigned
%endif

%define desc_generic \
GNU GRUB is a multiboot boot loader. It was derived from GRUB. It is an \
attempt to produce a boot loader for IBM PC-compatible machines that \
has both the ability to be friendly to beginning or otherwise \
nontechnically interested users and the flexibility to help experts in \
diverse environments. It is compatible with Free/Net/OpenBSD and Linux. \
It supports Win 9x/NT and OS/2 via chainloaders. It has a menu \
interface and a command line interface. \
It implements the Multiboot standard, which allows for flexible loading \
of multiple boot images (needed for modular kernels such as the GNU Hurd).

%description
%desc_generic

%description common
%desc_generic

This package carries the shared code and data.

%description pc
%desc_generic

This package provides PC BIOS support.

%description efi
%desc_generic

This package provides UEFI systems support.

Please note that the official build is signed; this shouldn't
intervene in any way but rather provides means to cope with
UEFI SecureBoot (better described as Restricted Boot) firmware
when one can't disable it easily, doesn't want to, or needs not to.

%prep
%setup -b 5
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
#patch8 -p1
%patch9 -p1
%patch10 -p0
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

sed -i "/^AC_INIT(\[GRUB\]/ s/%version/%version-%release/" configure.ac

mv ../grub-extras-%version ./grub-extras

%ifarch %efi
cd ..
rm -rf %name-efi-%version
cp -a %name-%version %name-efi-%version
cd %name-efi-%version
%endif

%build
export GRUB_CONTRIB=`pwd`/grub-extras
./autogen.sh
%configure \
	TARGET_LDFLAGS=-static \
	--with-platform=%platform \
	--disable-werror

%make_build
# NB: make unicode.pf2 results in a broken font file, argh

%ifarch %efi
cd ../%name-efi-%version
export GRUB_CONTRIB=`pwd`/grub-extras
./autogen.sh
%configure \
	TARGET_LDFLAGS=-static \
	--with-platform=efi \
	--disable-werror

%make_build

# NB: 32-bit operation NOT tested at all (things are quite 64-bittish, btw)
%ifarch %ix86
%define grubefiarch i386-efi
%else
%define grubefiarch %_arch-efi
%endif

# NB: this isn't tested all too well, might be broken or lacking;
#     grub-install --target=x86_64-efi will assemble another one
./grub-mkimage -O %grubefiarch -o grub.efi -d grub-core -p "" \
	part_gpt hfsplus fat ext2 btrfs normal chain boot configfile linux \
	appleldr minicmd loadbios reboot halt search font gfxterm
%endif

%install
export GRUB_CONTRIB=`pwd`/grub-extras
%makeinstall_std

install -pDm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/%name

%find_lang grub

mkdir -p %buildroot/boot/grub/fonts

install -pD -m755 %SOURCE8 %buildroot%_sbindir/
install -pD -m644 %SOURCE9 %buildroot%_man8dir/update-grub.8

# TODO: drop the obsolete one (unifont.pf2)
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/unifont.pf2 %_datadir/fonts/bitmap/misc/8x13.pcf.gz
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/fonts/unicode.pf2 %font

mkdir -p %buildroot/boot/grub/themes

install -pDm755 %SOURCE3 %buildroot%_sysconfdir/grub.d/
sed -i 's,^libdir=,libdir=%_libdir,g' %buildroot%_sysconfdir/grub.d/39_memtest
sed -i 's,@LOCALEDIR@,%_datadir/locale,g' %buildroot%_sysconfdir/grub.d/*

install -pDm755 %SOURCE4  %buildroot%_rpmlibdir/grub2.filetrigger
install -pDm755 %SOURCE6  %buildroot%_sbindir/grub-autoupdate
install -pDm755 %SOURCE10 %buildroot%_sbindir/grub-efi-autoupdate

# Ghost config file
install -d %buildroot/boot/grub
touch %buildroot/boot/grub/grub.cfg
ln -s ../boot/grub/grub.cfg %buildroot%_sysconfdir/grub.cfg

# Docs/habits compat symlink
mkdir -p %buildroot%_sysconfdir/default
ln -s ../sysconfig/%name %buildroot%_sysconfdir/default/grub

%ifarch %efi
cd ../%name-efi-%version
%makeinstall_std

install -pDm644 grub.efi %buildroot%_efi_bindir/grub.efi
cd -

# NB: UEFI GRUB2 image gets signed when build environment is set up that way
%ifarch x86_64
%pesign -s -i %buildroot%_efi_bindir/grub.efi
%endif

# Remove headers
rm -f %buildroot%_libdir/grub-efi/*/*.h
%endif

%files common -f grub.lang
%dir %_sysconfdir/grub.d
%dir %_libdir/grub
%dir /boot/grub
/boot/grub/*.pf2
/boot/grub/fonts/
/boot/grub/themes/
%_sysconfdir/grub.d/00_header
%_sysconfdir/grub.d/05_altlinux_theme
%_sysconfdir/grub.d/10_linux
%_sysconfdir/grub.d/20_linux_xen
%_sysconfdir/grub.d/30_os-prober
%_sysconfdir/grub.d/39_memtest
%config(noreplace) %_sysconfdir/grub.d/40_custom
%config(noreplace) %_sysconfdir/sysconfig/%name
%_sysconfdir/default/grub
%_sysconfdir/bash_completion.d/grub
%_sbindir/grub-bios-setup
%_sbindir/grub-install
%_sbindir/grub-mkconfig
%_sbindir/grub-mknetdir
%_sbindir/grub-ofpathname
%_sbindir/grub-probe
%_sbindir/grub-reboot
%_sbindir/grub-set-default
%_sbindir/grub-sparc64-setup
%_sbindir/update-grub
%_bindir/grub-editenv
%_bindir/grub-fstest
%_bindir/grub-kbdcomp
%_bindir/grub-menulst2cfg
%_bindir/grub-mkstandalone
%_bindir/grub-mkfont
%_bindir/grub-mklayout
%_bindir/grub-mkimage
%_bindir/grub-mkpasswd-pbkdf2
%_bindir/grub-mkrelpath
%_bindir/grub-script-check
%ifnarch ppc ppc64
%_bindir/grub-mkrescue
%endif
%_datadir/grub/grub-mkconfig_lib
%_man1dir/*
%_man8dir/*
%_infodir/grub.info.*
%_infodir/grub-dev.info.*

%files pc
%_libdir/grub/*-%platform/
%config(noreplace) %_sysconfdir/grub.cfg
%ghost %config(noreplace) /boot/grub/grub.cfg
%_sbindir/grub-autoupdate
%_rpmlibdir/%name.filetrigger

%ifarch %efi
%ifarch x86_64
%files efi
%_efi_bindir/grub.efi
%else
%files efi
%endif
%_efi_bindir/grub.efi
%_libdir/grub/%grubefiarch
%_sbindir/grub-efi-autoupdate
%endif

# see #27935: grub1 would have /usr/lib/grub -> /boot/grub symlink
%pre common
[ -L %_libdir/grub ] && rm -f %_libdir/grub ||:

%post pc
grub-autoupdate || {
	echo "** WARNING: grub-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run it by hand, record the output offline,"
	echo "** WARNING: make sure you have bootable rescue CD/flash media handy"
	echo "** WARNING: and try \`grub-install /dev/sdX' manually"
} >&2

%post efi
modprobe efivars
grep -q '^GRUB_DISTRIBUTOR=' %_sysconfdir/sysconfig/%name ||
	echo 'GRUB_DISTRIBUTOR="ALT Linux"' >> %_sysconfdir/sysconfig/%name

grep -q '^GRUB_BOOTLOADER_ID=' %_sysconfdir/sysconfig/%name ||
	echo 'GRUB_BOOTLOADER_ID="altlinux"' >> %_sysconfdir/sysconfig/%name

grub-efi-autoupdate || {
	echo "** WARNING: grub-efi-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run it by hand, record the output offline,"
	echo "** WARNING: make sure you have e.g. rEFInd bootable media handy"
} >&2

%changelog
