Name: gsasl
%define libname lib%name
Version: 1.8.0
Release: alt1

Summary: GNU SASL implementation
Group: System/Libraries
License: GPLv3+
Url: http://www.gnu.org/software/gsasl/
# ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
Source: %name-%version.tar

Requires: lib%name = %version-%release

# Automatically added by buildreq on Thu Dec 08 2011
BuildRequires: gtk-doc libgnutls-devel libidn-devel libkrb5-devel libntlm-devel libreadline-devel

%description
GNU SASL is an implementation of the Simple Authentication and
Security Layer framework and a few common SASL mechanisms.

%package -n lib%name
Summary: GNU SASL library
Group: System/Libraries
License: LGPLv2+

%description -n lib%name
GNU SASL is an implementation of the Simple Authentication and
Security Layer framework and a few common SASL mechanisms.

This package contains lib%name runtime library.

%package -n lib%name-devel
Summary: Files for development of lib%name-based applications
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains files for development of applications
which will use lib%name.

%prep
%setup
sed -i 's/^AM_CPPFLAGS +=/& \$(GSS_CFLAGS)/' lib/gl/Makefile.*

%build
%autoreconf
%configure \
	--disable-static \
	--enable-shared \
	--disable-rpath \
	--disable-silent-rules \
	--with-libgcrypt \
	--with-gssapi-impl=mit \
	--disable-obsolete
%make_build

%install
%makeinstall_std
%find_lang %name
sed -i '/libgsasl\.mo/d' %name.lang
%find_lang lib%name

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
%make_build -k check

%files -f %name.lang
%_bindir/*
%_man1dir/*
%doc AUTHORS NEWS README THANKS

%files -n lib%name -f lib%name.lang
%_libdir/*.so.*
%doc lib/AUTHORS lib/NEWS lib/README lib/THANKS

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*.h
%_pkgconfigdir/*.pc
%_infodir/*
%_man3dir/*

%changelog
