%define gst_plugins gst-plugins
%define ver_major 0.10

%define _gst_libdir %_libdir/gstreamer-%ver_major
%define _gtk_docdir %_datadir/gtk-doc/html

%def_enable gtk_doc

Name: %gst_plugins-bad
Version: %ver_major.23
Release: alt2
Summary: A set of GStreamer plugins that need more quality
Group: System/Libraries
License: LGPL
URL: http://gstreamer.freedesktop.org/

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: lib%gst_plugins >= 0.10.3
Requires: gstreamer >= 0.10.3
Conflicts: %gst_plugins-good < %ver_major.15.4

Obsoletes: %gst_plugins-farsight <= 0.12.11
Provides: %gst_plugins-farsight = 0.12.20

Source0: %name-%version.tar
Source1: common.tar
Patch: %name-%version-%release.patch

BuildRequires: bzlib-devel gcc-c++ gst-plugins-devel gtk-doc intltool libSDL-devel libX11-devel
BuildRequires: libalsa-devel libcdaudio-devel libdca-devel libdirac-devel libdvdnav-devel libexif-devel
BuildRequires: libfaad-devel libgio-devel libgsm-devel libjasper-devel libmjpegtools-devel libmms-devel
BuildRequires: libmpcdec-devel libneon-devel liboil-devel libsoundtouch-devel libssl-devel libmodplug-devel
BuildRequires: libtimidity-devel libxvid-devel python-module-PyXML python-modules-email python-modules-encodings
BuildRequires: timidity-instruments libcelt-devel libdc1394-devel libkate-devel libtiger-devel
BuildRequires: libvpx-devel librtmp-devel liborc-devel orc libofa-devel libmusicbrainz-devel libass-devel
BuildRequires: libzbar-devel

%description
GStreamer Bad Plug-ins is a set of plug-ins that aren't up to par
compared to the rest.  They might be close to being good quality, but
they're missing something - be it a good code review, some
documentation, a set of tests, a real live maintainer, or some actual
wide use.  If the blanks are filled in they might be upgraded to
become part of either gst-plugins-good or gst-plugins-ugly, depending
on the other factors.

%package devel
Summary: Development files for GStreamer plugins
Group: Development/C

%description devel
This package contains the libraries, headers and other files necessary
to develop GStreamer plugins.

%package doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for %name

%prep
%setup -q -a1
%patch -p1

touch ABOUT-NLS config.rpath

%build
gtkdocize
%autoreconf
%configure \
    --disable-examples \
    --enable-experimental \
    %{subst_enable gtk_doc} \
    --disable-static \
    --with-html-dir=%_gtk_docdir

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-%ver_major

%files -f %name-%ver_major.lang
%doc AUTHORS NEWS README RELEASE
%_libdir/*.so.*
%dir %_gst_libdir
%_gst_libdir/*.so
%_datadir/glib-2.0/schemas/*.xml

%files devel
%_includedir/gstreamer-0.10
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files doc
%_gtk_docdir/gst-plugins-bad-plugins-0.10
%_gtk_docdir/gst-plugins-bad-libs-0.10
%endif

%changelog
