%define gst_plugins gst-plugins
%define ver_major 0.10

%define _gst_libdir %_libdir/gstreamer-%ver_major
%define _gtk_docdir %_datadir/gtk-doc/html

Name: %gst_plugins-base
Version: %ver_major.36
Release: alt1
Summary: An essential set of GStreamer plugins
Group: System/Libraries
License: LGPL
URL: http://gstreamer.freedesktop.org/

Requires: lib%gst_plugins = %version-%release
Requires: gstreamer

Provides: gstreamer(audio-hardware-sink) = %version
Provides: gstreamer(audio-hardware-source) = %version

Provides: %name-audio-filters = %version-%release
Provides: %name-test = %version-%release
Provides: %name-video-filters = %version-%release
Provides: %name-network = %version-%release
Provides: %name-subtitle = %version-%release
Provides: %gst_plugins-all = %version-%release
Provides: %gst_plugins-network = %version-%release
Provides: %gst_plugins-subtitle = %version-%release
Provides: %gst_plugins-test = %version-%release
Provides: %gst_plugins-audio-filters = %version-%release
Provides: %gst_plugins-audio-formats = %version-%release
Provides: %gst_plugins-video-filters = %version-%release
Provides: %gst_plugins-video-formats = %version-%release
Provides: %gst_plugins-video-effects = %version-%release
Provides: %gst_plugins-container-formats = %version-%release
Provides: %gst_plugins-alsa = %version-%release
Provides: %gst_plugins-cdparanoia = %version-%release
Provides: %gst_plugins-ogg = %version-%release
Provides: %gst_plugins-theora = %version-%release
Provides: %gst_plugins-vorbis = %version-%release
Provides: %gst_plugins-ximagesink = %version-%release
Provides: %gst_plugins-xvideo = %version-%release
Provides: %gst_plugins-libvisual = %version-%release
Provides: %gst_plugins-visualization = %version-%release
Provides: %gst_plugins-gnomevfs = %version-%release
Provides: %gst_plugins-gio = %version-%release
Provides: %gst_plugins-pango = %version-%release

Obsoletes: %gst_plugins-all < %version
Obsoletes: %gst_plugins-network < %version
Obsoletes: %gst_plugins-subtitle < %version
Obsoletes: %gst_plugins-test < %version
Obsoletes: %gst_plugins-audio-formats < %version
Obsoletes: %gst_plugins-audio-filters < %version
Obsoletes: %gst_plugins-video-formats < %version
Obsoletes: %gst_plugins-video-filters < %version
Obsoletes: %gst_plugins-video-effects < %version
Obsoletes: %gst_plugins-container-formats < %version
Obsoletes: %gst_plugins-libvisual < %version
Obsoletes: %gst_plugins-visualization < %version
Obsoletes: %gst_plugins-gnomevfs < %version
Obsoletes: %gst_plugins-gio < %version
Obsoletes: %gst_plugins-pango < %version

Source: %name-%version.tar
Source1: common.tar
Patch: %name-%version-%release.patch

BuildRequires: gstreamer-devel gtk-doc intltool libSM-devel libXext-devel libXv-devel libalsa-devel libgtk+2-devel
BuildRequires: libcdparanoia-devel liboil-devel libtheora-devel libvorbis-devel orc liborc-test-devel gstreamer-gir-devel
BuildRequires: python-module-PyXML python-modules-encodings gobject-introspection-devel

%description
GStreamer Base Plug-ins is a well-groomed and well-maintained
collection of GStreamer plug-ins and elements, spanning the range of
possible types of elements one would want to write for GStreamer. A
wide range of video and audio decoders, encoders, and filters are
included.

%package -n lib%gst_plugins
Summary: GStreamer plugin libraries
Group: System/Libraries
Conflicts: %gst_plugins-bad <= 0.10.9

%description -n lib%gst_plugins
Helper libraries for GStreamer plugins, containing base classes useful for elements

%package -n lib%gst_plugins-gir
Summary: GObject introspection data for the GStreamer library
Group: System/Libraries
Requires: lib%gst_plugins = %version-%release

%description -n lib%gst_plugins-gir
GObject introspection data for the GStreamer library

%package -n %gst_plugins-tools
Summary: GStreamer plugin tools
Group: Development/Other
Requires: %name = %version-%release

%description -n %gst_plugins-tools
This package contains a few test tools from the
GStreamer Base Plugins distribution.

%package -n %gst_plugins-devel
Summary: Development files for GStreamer plugins
Group: Development/C
Requires: lib%gst_plugins = %version-%release gstreamer-devel

%description -n %gst_plugins-devel
This package contains the libraries, headers and other files necessary
to develop GStreamer plugins.

%package -n %gst_plugins-gir-devel
Summary: GObject introspection devel data for the GStreamer library
Group: System/Libraries
BuildArch: noarch
Requires: lib%gst_plugins-gir = %version-%release %gst_plugins-devel = %version-%release

%description -n %gst_plugins-gir-devel
GObject introspection devel data for the GStreamer library

%prep
%setup -q -a1
%patch -p1

touch ABOUT-NLS config.rpath
subst '/.PHONY/d' Makefile.am

%build
%autoreconf
%configure \
	--with-default-audiosrc=pulsesrc \
	--with-default-audiosink=pulsesink \
	--with-default-videosrc=v4l2src \
	--with-default-videosink=xvimagesink \
	--disable-examples \
	--disable-valgrind \
	--enable-gtk-doc \
	--enable-experimental \
	--enable-gio \
	--disable-debug \
	--disable-static \
	--with-html-dir=%_gtk_docdir
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-%ver_major

%files -f %name-%ver_major.lang
%dir %_gst_libdir
%_gst_libdir/*.so
%_datadir/%name/*.dict

%files -n lib%gst_plugins
%_libdir/*.so.*
%dir %_gst_libdir

%files -n lib%gst_plugins-gir
%_libdir/girepository-1.0/*.typelib

%files -n %gst_plugins-tools
%_bindir/*-%ver_major
%_man1dir/*

%files -n %gst_plugins-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_gtk_docdir/%name-*-%ver_major

%files -n %gst_plugins-gir-devel
%_datadir/gir-1.0/*.gir

%changelog
