%define gst_plugins gst-plugins
%define ver_major 0.10

%define _gst_datadir %_datadir/gstreamer-%ver_major
%define _gst_libdir %_libdir/gstreamer-%ver_major
%define _gtk_docdir %_datadir/gtk-doc/html

Name: %gst_plugins-good
Version: %ver_major.31
Release: alt2
Summary: A set of GStreamer plugins considered good
Group: System/Libraries
License: LGPL
URL: http://gstreamer.freedesktop.org/

Packager: Valery Inozemtsev <shrek@altlinux.ru>

PreReq(post): GConf
Conflicts: %gst_plugins-bad < %ver_major.22
Provides: %name-audio-formats = %version-%release
Provides: %name-container-formats = %version-%release
Provides: %name-tags = %version-%release
Provides: %name-video-filters = %version-%release
Provides: %gst_plugins-flac = %version-%release
Provides: %gst_plugins-gconf = %version-%release
Obsoletes: %gst_plugins-gconf < %version

Source: %name-%version.tar
Source1: common.tar
Patch: %name-%version-%release.patch

BuildRequires(Pre): libGConf-devel
BuildRequires: GConf bzlib-devel gcc-c++ gst-plugins-devel gtk-doc intltool libSM-devel libXdamage-devel libXext-devel
BuildRequires: libXv-devel libavc1394-devel libcairo-devel libdv-devel libflac-devel libiec61883-devel libjpeg-devel
BuildRequires: liboil-devel libpulseaudio-devel libshout2-devel libsoup-devel libtag-devel libv4l-devel libwavpack-devel
BuildRequires: python-module-PyXML python-modules-email python-modules-encodings liborc-devel orc libgdk-pixbuf-devel
BuildRequires: libjack-devel libpng-devel libcairo-gobject-devel libgudev-devel libspeex-devel zlib-devel

%description
GStreamer Good Plug-ins is is a set of plug-ins that the developers consider
to have good quality code, correct functionality, and their preferred license
(LGPL for the plug-in code, LGPL or LGPL-compatible for the supporting
library).

%package devel-doc
Summary: Development documentation for GStreamer Good plugins
Group: Development/C
BuildArch: noarch

%description devel-doc
This package contains development documentation for GStreamer Good Plugins

%prep
%setup -q -a1
%patch -p1

touch ABOUT-NLS config.rpath

%build
%autoreconf
%configure \
	--enable-experimental \
	--disable-examples \
	--disable-valgrind \
	--disable-oss \
	--disable-oss4 \
	--enable-gtk-doc \
	--disable-debug \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-%ver_major

%post
%gconf2_install gstreamer-0.10

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall gstreamer-0.10
fi

%files -f %name-%ver_major.lang
%doc AUTHORS NEWS README RELEASE
%_sysconfdir/gconf/schemas/gstreamer-0.10.schemas
%dir %_gst_libdir
%_gst_libdir/*.so
%_gst_datadir

%files devel-doc
%_gtk_docdir/*

%changelog
