%define gst_plugins gst-plugins
%define ver_major 0.10

%define _gst_libdir %_libdir/gstreamer-%ver_major
%define _gtk_docdir %_datadir/gtk-doc/html

Name: %gst_plugins-ugly
Version: %ver_major.19
Release: alt1
Summary: A set of encumbered GStreamer plugins
Group: System/Libraries
License: LGPL
URL: http://gstreamer.freedesktop.org/

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: gstreamer >= 0.10.6
Requires: lib%gst_plugins >= 0.10.3

Provides: %gst_plugins-lame = %version-%release
Provides: %gst_plugins-mad = %version-%release

Conflicts: %gst_plugins-bad < 0.10.13

Source: %name-%version.tar
Source1: common.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ gst-plugins-devel gtk-doc intltool liba52-devel libcdio-devel libid3tag-devel
BuildRequires: liblame-devel libmad-devel libmpeg2-devel liboil-devel libx264-devel python-module-PyXML
BuildRequires: python-modules-encodings libopencore-amrnb-devel libopencore-amrwb-devel libdvdread-devel
BuildRequires: liborc-devel orc

%description
GStreamer Ugly Plug-ins is a set of plug-ins that have good quality
and correct functionality, but distributing them might pose problems.
The license on either the plug-ins or the supporting
libraries might not be how the developers would like.
The code might be widely known to present patent problems.

%package devel-doc
Summary: Development documentation for GStreamer Ugly plugins
Group: Development/C
BuildArch: noarch

%description devel-doc
This package contains development documentation for GStreamer Ugly plugin
collection.

%prep
%setup -q -a1
%patch -p1

touch ABOUT-NLS config.rpath

%build
%autoreconf
%configure \
	--disable-examples \
	--enable-experimental \
	--enable-gtk-doc \
	--disable-static \
	--with-html-dir=%_gtk_docdir
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-%ver_major

%files -f %name-%ver_major.lang
%doc AUTHORS NEWS README RELEASE
%dir %_gst_libdir
%_gst_libdir/*.so
%_datadir/gstreamer-%ver_major

%files devel-doc
%_gtk_docdir/%name-plugins-%ver_major

%changelog
