Name: gtk-doc
Version: 1.19
Release: alt1

Summary: API documentation generation tool for GTK+ and GNOME
Group: Development/Other
License: %gpl2plus
Url: http://www.gtk.org/gtk-doc/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

%define pkgdocdir %_docdir/%name-%version

Requires: sgml-common >= 0.6.3-alt11
Requires: docbook-dtds >= 4.3-alt1
Requires: docbook-style-xsl
Requires: libxml2 >= 2.3.6
Requires: xsltproc
Requires: perl-base >= 1:5.6.0
Requires: highlight
# for SGML
Requires: openjade >= 1.3.1
Requires: docbook-style-dsssl

# hack for broken perl autoreq
Provides: perl(gtkdoc-common.pl)

#Source: %name-%version.tar
Source: ftp://ftp.gnome.org/gnome/sources/%name/%version/%name-%version.tar.xz

BuildArch: noarch

BuildRequires: docbook-dtds xml-common xml-utils
BuildRequires: common-licenses rpm-build-licenses rpm-build-gnome
BuildRequires: yelp-tools
BuildRequires: docbook-dtds >= 1.0-alt7
BuildRequires: docbook-style-xsl
BuildRequires: perl-base >= 1:5.6.0 bc highlight
# for SGML
BuildRequires: docbook-style-dsssl
BuildRequires: openjade >= 1.3.1
# for check
BuildRequires: glib2-devel

%description
%name is a tool for generating API reference documentation.
it is used for generating the documentation for GTK+, GLib
and GNOME.

%package mkpdf
Summary: PDF converter for %name
Group: Development/Other
Requires: %name = %version-%release

%description mkpdf
%name is a tool for generating API reference documentation.
it is used for generating the documentation for GTK+, GLib
and GNOME.

This package provides utility for saving documentation in PDF format

%package manual
Summary: Manual for gtk-doc
Group: Development/Other
License: %fdl
Requires(post,postun): scrollkeeper

%description manual
Manual for gtk-doc, a tool for generating API reference documentation
used by GTK+, GLib and GNOME.

%prep
%setup

# Move this doc file to avoid name collisions
mv doc/README doc/README.docs
rm -f examples/*~

%build
%autoreconf
%undefine _configure_target
export ac_cv_path_JADE=%_bindir/openjade
export ac_cv_path_XSLTPROC=%_bindir/xsltproc
# dblatex or fop (xmlgraphics-fop) required for pdf output
export ac_cv_path_DBLATEX=%_bindir/dblatex
%configure \
    --with-xml-catalog=%_sysconfdir/xml/catalog \
    --docdir=%pkgdocdir \
    --with-highlight=highlight
%make_build

%check
%make check

%install
%make_install DESTDIR=%buildroot pkgconfigdir=%_datadir/pkgconfig install
install -d -m755 %buildroot%_datadir/gtk-doc/html
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d/
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^%_datadir/(gtk-doc|gnome|bonobo)/html/.
EOF

%find_lang --with-gnome gtk-doc-manual

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS ChangeLog MAINTAINERS NEWS README TODO doc/* \
    %buildroot%pkgdocdir/
bzip2 -9 %buildroot%pkgdocdir/ChangeLog
ln -s %_licensedir/GPL-2 %buildroot%pkgdocdir/COPYING
ln -s %_licensedir/FDL-1.1 %buildroot%pkgdocdir/COPYING-DOCS
cp -a examples %buildroot%pkgdocdir/


%files
%_bindir/*
%exclude %_bindir/gtkdoc-mkpdf
%_datadir/gtk-doc
%_datadir/sgml/gtk-doc
%_datadir/pkgconfig/*
%_datadir/aclocal/*
%_sysconfdir/buildreqs/files/ignore.d/*
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/COPYING
%pkgdocdir/ChangeLog.bz2
%pkgdocdir/MAINTAINERS
%pkgdocdir/NEWS
%pkgdocdir/README*
%pkgdocdir/TODO
%pkgdocdir/*.txt
%pkgdocdir/examples

%files mkpdf
%_bindir/gtkdoc-mkpdf

%files manual -f gtk-doc-manual.lang
%dir %pkgdocdir
%pkgdocdir/COPYING-DOCS

%changelog
