%define gtk2_ver 2.14.0
%define gtk2_binary_ver 2.10.0

%define gtk3_binary_ver 3.0.0

Name: gtk-xfce-engine
Summary: Xfce gtk theme engine with various different themes
Version: 3.0.0
Release: alt2
License: %gpl2plus
Url: http://www.xfce.org/
# Upstream: git://git.xfce.org/xfce/gtk-xfce-engine
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Group: Graphical desktop/XFce
Packager: XFCE Team <xfce@packages.altlinux.org>

BuildRequires(pre): rpm-build-licenses

BuildRequires: rpm-build-xfce4 >= 0.1.1 xfce4-dev-tools
BuildRequires: libICE-devel libXt-devel xorg-cf-files
BuildRequires: libgtk+2-devel >= %gtk2_ver libgtk+3-devel

%description
This package provides the Xfce Gtk+-2.0 and Gtk+-3.0 engines,
which allows for homogeneity in applications for both business and
personal desktops.

%package -n gtk2-themes-xfce4
Summary: Xfce Gtk+-2.0 engine and themes
Group: Graphical desktop/XFce
Obsoletes: gtk-engines-xfce < 2.8.1
Provides: gtk-engines-xfce = %version-%release
Obsoletes: libgtk-engines-xfce4 < 2.8.1
Provides: libgtk-engines-xfce4 = %version-%release

%description -n gtk2-themes-xfce4
This package provides the Xfce Gtk+-2.0 engine, which allows for
homogeneity in applications for both business and personal desktops.

%package -n gtk3-themes-xfce4
Summary: Xfce Gtk+-3.0 engine and themes
Group: Graphical desktop/XFce

%description -n gtk3-themes-xfce4
This package provides the Xfce Gtk+-3.0 engine, which allows for
homogeneity in applications for both business and personal desktops.

%prep
%setup
%patch -p1

# Don't use git tag in version.
%xfce4_drop_gitvtag gtk_xfce_engine_version_tag configure.in.in

%build
%xfce4reconf
touch ChangeLog
%configure \
	--disable-static \
	--enable-gtk2 \
	--enable-gtk3 \
	--enable-debug=no
%make_build

%install
%makeinstall_std

%files -n gtk2-themes-xfce4
%exclude %_libdir/gtk-2.0/%gtk2_binary_ver/engines/*.la
%_libdir/gtk-2.0/%gtk2_binary_ver/engines/*.so
%dir %_datadir/themes/*
%_datadir/themes/*/gtk-2.0
%doc AUTHORS

%files -n gtk3-themes-xfce4
%exclude %_libdir/gtk-3.0/%gtk3_binary_ver/theming-engines/*.la
%_libdir/gtk-3.0/%gtk3_binary_ver/theming-engines/*.so
%dir %_datadir/themes/*
%_datadir/themes/*/gtk-3.0
%doc AUTHORS

%changelog
