Name: gtkpod
Version: 2.1.2
Release: alt4
Summary: A GUI for Apple's iPod using GTK2
License: GPL
Group: Sound
Url: http://www.gtkpod.org/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: lib%name = %version-%release

BuildRequires: flex mount intltool desktop-file-utils zlib-devel gcc-c++
BuildRequires: libgdk-pixbuf-devel
BuildRequires: libgtk+3-devel >= 3.0.8
BuildRequires: glib2-devel >= 2.28.5
BuildRequires: libglade-devel >= 2.4.0
BuildRequires: libgpod-devel >= 0.7.0
BuildRequires: anjuta-devel >= 2.91.0
BuildRequires: libgdl3-devel >= 3.0.0
BuildRequires: libgio-devel >= 2.28.5
BuildRequires: libxml2-devel >= 2.7.7
BuildRequires: libid3tag-devel >= 0.15
BuildRequires: libcurl-devel >= 7.10.0
BuildRequires: libwebkitgtk3-devel >= 1.3
BuildRequires: libclutter-gtk3-devel >= 1.0
BuildRequires: gstreamer-devel >= 0.10.25 gst-plugins-devel  >= 0.10.25
BuildRequires: libflac-devel  libvorbis-devel faad
BuildRequires: glibc-kernheaders glibc-devel
BuildRequires: libbrasero-devel libmusicbrainz4-devel libdiscid-devel

%add_findreq_skiplist %_datadir/%name/scripts/*

%description
gtkpod is a platform independent Graphical User Interface for Apple's
iPod using GTK2. It supports the first to fifth Generation including
the iPod mini, iPod Photo, iPod Shuffle, iPod nano, and iPod Video.

%package -n lib%name
Group: System/Libraries
Summary: Shared library part of %name

%description -n lib%name
This is the shared library part of %{name}.

%package -n lib%name-devel
Group: Development/C
Summary: Development files for %name
Requires: lib%name = %version-%release

%description -n lib%name-devel
This is the development part of %{name}.


%prep
%setup -q
%patch -p1
echo "%version" > version

%build
%autoreconf
%configure --disable-static
%make

%install
%makeinstall_std
%find_lang %name

sed -i "s|%_prefix/lib|%_libdir|g" %buildroot%_datadir/%name/scripts/sync-evolution.sh

desktop-file-install --vendor="" \
  --add-mime-type="x-content/audio-player" \
  --dir %buildroot%_datadir/applications %buildroot%_datadir/applications/*
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=AudioVideo \
	--add-category=TelephonyTools \
	--add-category=Utility \
	%buildroot%_desktopdir/gtkpod.desktop

%files -f %name.lang
%doc README AUTHORS ChangeLog
%_bindir/%name
%dir %_libdir/%name
%_libdir/%name/*.plugin
%_libdir/%name/*.so
%_desktopdir/%name.desktop
%_datadir/glib-2.0/schemas/*.gschema.xml
%_datadir/%name
%_iconsdir/hicolor/*/apps/%name.*
%_man1dir/%name.*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*.pc
%_includedir/gtkpod

%exclude %_libdir/%name/*.la

%changelog
