%def_enable introspection
%define ver_major 3.8
%define api_ver 2.90

Name: gucharmap
Version: %ver_major.2
Release: alt1

Summary: gucharmap is a featureful Unicode character map
License: %gpl3plus
Group: Text tools

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# From configure.ac
%define glib_ver 2.32.0
%define gtk_ver 3.4.0

Requires: lib%name = %version-%release

BuildPreReq: rpm-build-gnome rpm-build-licenses
# From configure.ac
BuildPreReq: intltool >= 0.40.0
BuildRequires: gnome-common desktop-file-utils
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildRequires: yelp-tools itstool
BuildPreReq: gtk-doc >= 1.0
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libgtk+3-gir-devel}

%description
This package provides a featureful Unicode character map for GNOME.

%package -n lib%name
Summary: Shared library needed to run %name
Group: System/Libraries

%description -n lib%name
This package provides shared library for programs that show character maps
(including Gucharmap and a character map applet for the GNOME panel).

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains headers and libraries needed to compile
applications against lib%name

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GNOME Unicode character map library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GNOME Unicode character map library

%prep
%setup -q

%build
%configure \
    --disable-static \
    --disable-schemas-compile \
    %{subst_enable introspection}

%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%config %_datadir/glib-2.0/schemas/org.gnome.Charmap.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Charmap.enums.xml
%doc AUTHORS NEWS README TODO COPYING.UNICODE

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Gucharmap-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Gucharmap-%api_ver.gir
%endif

%changelog
