%define iname guile
%define sversion 1.8

Summary: A GNU implementation of Scheme for application extensibility
Name: %{iname}18
Version: %sversion.7
Release: alt2.4
Serial: 1
Url: http://www.gnu.org/software/guile/

License: GPL
Group: Development/Scheme

Obsoletes: %iname <= 1.4.1
Provides: %iname = %serial:%version-%release
Provides: /usr/bin/guile

Packager: Alex Karpov <karpov@altlinux.org>

Source: ftp://alpha.gnu.org/gnu/%iname/%iname-%version.tar
Source1: %name.alternatives

Patch: guile18-snarf-check-and-output-texi.scm.patch

Patch2: guile-1.8.7-testsuite.patch
Patch3: guile-1.8.7-testsuite2.patch

# Automatically added by buildreq on Wed Feb 07 2007
BuildRequires: gcc-c++ glibc-devel-static libgmp-devel libltdl-devel libncurses-devel libreadline-devel sendmail-common 

%add_findreq_skiplist %_datadir/%iname/%sversion/scripts/*

%description
GUILE (GNU's Ubiquitous Intelligent Language for Extension) is a library
implementation of the Scheme programming language, written in C.  GUILE
provides a machine-independent execution platform that can be linked in
as a library during the building of extensible programs.

%package devel
Summary: A GNU implementation of Scheme for application extensibility
Group: Development/Scheme
Requires: %name = %serial:%version-%release
Requires: libgmp-devel
Obsoletes: %iname-devel <= 1.4.1
Provides: %iname-devel = %serial:%version-%release
Conflicts: guile14-devel guile16-devel

%description devel
GUILE (GNU's Ubiquitous Intelligent Language for Extension) is a library
implementation of the Scheme programming language, written in C.  GUILE
provides a machine-independent execution platform that can be linked in
as a library during the building of extensible programs.

Install this package if you are going to develop extendable programs.

%package devel-static
Summary: A GNU implementation of Scheme for application extensibility
Group: Development/Scheme
Requires: %name-devel = %serial:%version-%release
Obsoletes: %iname-devel-static <= 1.4.1
Provides: %iname-devel-static = %serial:%version-%release

%description devel-static
GUILE (GNU's Ubiquitous Intelligent Language for Extension) is a library
implementation of the Scheme programming language, written in C.  GUILE
provides a machine-independent execution platform that can be linked in
as a library during the building of extensible programs.

Install this package if you need to statically link your program with guile.

%prep
%setup -q -n %iname-%version
%patch -p1

%patch2 -p1
%patch3 -p1

%__subst -p 's/^libguile_la_LDFLAGS = .*/& $(GUILE_CFLAGS)/' libguile/Makefile*

%build
#ifarch x86_64
#define _optlevel 0
#endif

%autoreconf

%configure --with-threads --enable-error-on-warning=no
#NO SMP
%make

%install
#export LD_LIBRARY_PATH=$RPM_BUILD_ROOT%_libdir
#make install DESTDIR=$RPM_BUILD_ROOT LDFLAGS=-L$RPM_BUILD_ROOT%_libdir
%makeinstall

#alternatives stuff
install -pD -m644 %SOURCE1 %buildroot%_altdir/%name
mv %buildroot%_bindir/%iname %buildroot%_bindir/%name

%check
make check

%files
%_bindir/%name
%dir %_datadir/%iname
%dir %_datadir/%iname/%sversion
%_libdir/lib*.so.*
%_libdir/lib%iname?*.so
%_datadir/%iname/%sversion/*
%_altdir/%name
%_mandir/man1/%iname.1.gz

%files devel
%_bindir/%iname-snarf
%_bindir/%iname-config
%_bindir/%iname-tools
%_libdir/lib%iname.so
%_includedir/*
%_datadir/aclocal/*
%_datadir/info/*.info*
%_libdir/pkgconfig/%iname-%sversion.pc

%files devel-static
%_libdir/lib*.a

%changelog
