Name: gutenprint
Version: 5.2.9
Release: alt1
Epoch: 1
Summary: Gutenprint Printer Drivers
Group: Publishing
License: GPLv2+
Requires: lib%name = %version-%release, ghostscript
Url: http://gimp-print.sourceforge.net/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: http://download.sourceforge.net/gimp-print/%name-%version.tar.bz2
Patch0: gutenprint-5.2.8-alt-fixes.patch
Patch1: gutenprint-5.2.9-alt-makefile.patch
Patch2: gutenprint-5.2.9-alt-LFS.patch

# Automatically added by buildreq on Sat Jun 16 2012
# optimized out: fontconfig fontconfig-devel glib2-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgtk+2-devel libncurses-devel libpango-devel libtinfo-devel libwayland-client libwayland-server pkg-config xz zlib-devel
BuildRequires: flex foomatic-db-engine libcups-devel libgimp-devel libijs-devel libreadline-devel

%description
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.
Gutenprint was formerly called Gimp-Print.

%package -n lib%name
Summary: Shared libraries for high-quality image printing
Group: Publishing

%description -n lib%name
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains gutenprint shared libraries.

%package -n lib%name-devel
Summary: Library development files for gutenprint
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains header files and libraries required to build
gutenprint-based software.

%package -n gimp-plugin-%name
Summary: GIMP plug-in for %name
Group: Publishing
Requires: %name = %version-%release gimp

%description -n gimp-plugin-%name
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains the gutenprint GIMP plug-in.

%package foomatic
Summary: Foomatic printer database information for %name
Group: Publishing
Requires: %name = %version-%release
PreReq: foomatic-db >= 3.0.1
BuildArch: noarch

%description foomatic
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains a database of printers, printer drivers,
and driver descriptions.

%package CUPS
Summary: CUPS drivers for Canon, Epson, HP and compatible printers
Group: Publishing
Requires: %name = %version-%release

%description CUPS
Gutenprint is a package of high quality printer drivers for Linux and
other UNIX-alike operating systems.

This package contains native CUPS support for a wide range of Canon,
Epson, HP and compatible printers.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p2
touch src/testpattern/testpatternl.l

%build
# remove old versions of standard macros
find m4* -type f -name \*.m4 -print0 |
	xargs -r0 grep -lxZ 'dnl Copyright (C) .* Free Software Foundation, Inc\.' -- |
	xargs -r0 rm -v --
rm m4*/libtool.m4
%autoreconf
%configure \
	--enable-shared \
	--disable-static \
	--disable-rpath \
	--with-modules=dlopen \
	--with-cups \
	--with-foomatic \
	--with-foomatic3 \
	--with-gimp2 \
	--with-gimp2-as-gutenprint \
	--enable-libgutenprintui2 \
	--enable-cups-ppds \
	--disable-translated-cups-ppds \
	--enable-cups-level3-ppds \
	--enable-cups-ppds-at-top-level

%make_build

%install
%makeinstall_std
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%_docdir
mv %buildroot%_datadir/%name/doc %buildroot%docdir
find %buildroot%_libdir/%name/ -name \*.la -delete
%find_lang %name
%set_verify_elf_method strict

%triggerpostun CUPS -- %name-CUPS < %version
cups=%_initdir/cups
if [ -x $cups ] && %_sbindir/cups-genppdupdate | grep -Fqs Restart; then
	$cups condreload
fi

%files -f %name.lang
%_bindir/ijs*
%_bindir/escputil
%_bindir/testpattern
%dir %_prefix/lib/cups
%_prefix/lib/cups/filter
%_datadir/%name/
%_man1dir/*.1*
%exclude %_datadir/locale/*/gutenprint_*.po
%dir %docdir
%docdir/[AFNR]*
%docdir/gutenprint-users-manual.pdf
%exclude %docdir/gutenprint-users-manual.odt
%exclude %docdir/C*

%files -n lib%name
%_libdir/*.so.*
%_libdir/%name

%files -n lib%name-devel
%_includedir/%{name}*
%_libdir/*.so
%_pkgconfigdir/*.pc
%dir %docdir
%docdir/%name.pdf
%docdir/reference-html

%files -n gimp-plugin-%name
%_libdir/gimp/2.0/plug-ins/%name

%files foomatic
%_datadir/foomatic/db/source/*/*.xml
%exclude %_datadir/foomatic/kitload.log

%files CUPS
%_sysconfdir/cups/*
%_bindir/cups-*
%_sbindir/cups-*
%dir %_prefix/lib/cups
%_prefix/lib/cups/driver
%_datadir/cups/model/C
%_datadir/cups/calibrate.ppm
%_man8dir/*.8*

%changelog
