%define ver_major 1.16
%def_enable http
%def_enable avahi
%def_enable cdda
%def_enable fuse
%def_disable hal
%def_enable obexftp
%def_enable gphoto2
%def_enable keyring
%def_enable samba
%def_enable archive
%def_disable gdu
%def_enable afc
%def_enable afp
%def_enable udisks2
%def_enable libmtp
%def_enable goa
%def_enable bluray
%def_enable gtk
%def_enable systemd_login
%def_disable gtk_doc

Name: gvfs
Version: %ver_major.4
Release: alt0.M70T.0.M70P.1

Summary: The GNOME virtual filesystem libraries
License: %lgpl2plus
Group: System/Libraries
URL: ftp://ftp.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar
Patch: gvfs-1.11.3-alt-gettext.patch
Patch1: gvfs-1.16.0-archive-integration.patch
Patch3: gvfs-1.14.1-libgvfsdaemon+headers_install.patch
Patch4: gvfs-1.16.2-alt-lfs.patch
Patch5: gvfs-1.15.4-alt-tmpfiles_dir.patch
# https://bugzilla.altlinux.org/show_bug.cgi?id=29047
# https://bugzilla.altlinux.org/show_bug.cgi?id=29171
# https://mail.gnome.org/archives/gvfs-list/2013-May/msg00014.html
Patch6: gvfs-1.16.3-alt-1-logind-state.patch
Patch7: gvfs-1.16.4-metatree-looping-on-large-entry.patch

%{?_enable_gdu:Obsoletes: gnome-mount <= 0.8}
%{?_enable_gdu:Obsoletes: gnome-mount-nautilus-properties <= 0.8}

# From configure.in
%define intltool_ver 0.35.0
%define glib_ver 2.35.3
%define libsoup_ver 2.41.3
%define avahi_ver 0.6
%define libcdio_paranoia_ver 0.82
%define hal_ver 0.5.10
%define bluez_ver 4.0
%define gdu_ver 3.3.91
%define udisks_ver 1.99
%define mtp_ver 1.1.5
%define goa_ver 3.7.90
%define libarchive_ver 3.0.22
%define imobiledevice_ver 1.1.5

Requires: dconf
%{?_enable_hal:Requires: gnome-mount}
%{?_enable_gdu:Requires: gnome-disk-utility >= %gdu_ver}
%{?_enable_udisks2:Requires: udisks2}

BuildPreReq: rpm-build-gnome rpm-build-licenses

# From configure.in
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: gtk-doc
BuildPreReq: openssh-clients
# hotplug backend
BuildRequires: libgudev-devel
# required if autoreconf used
BuildRequires: libgcrypt-devel
%{?_enable_gtk:BuildPreReq: libgtk+3-devel}
%{?_enable_http:BuildPreReq: libsoup-gnome-devel >= %libsoup_ver libxml2-devel}
%{?_enable_avahi:BuildPreReq: libavahi-glib-devel >= %avahi_ver libavahi-devel >= %avahi_ver}
%{?_enable_cdda:BuildPreReq: libcdio-devel >= %libcdio_paranoia_ver}
%{?_enable_fuse:BuildPreReq: libfuse-devel}
%{?_enable_hal:BuildPreReq: libhal-devel >= %hal_ver}
%{?_enable_obexftp:BuildPreReq: libbluez-devel >= %bluez_ver libdbus-glib-devel libexpat-devel}
%{?_enable_gphoto2:BuildPreReq: libgphoto2-devel}
%{?_enable_keyring:BuildPreReq: libsecret-devel}
%{?_enable_samba:BuildPreReq: libsmbclient-devel}
%{?_enable_archive:BuildPreReq: libarchive-devel >= %libarchive_ver}
%{?_enable_gdu:BuildPreReq: libgdu-devel >= %gdu_ver libgudev-devel}
%{?_enable_afc:BuildPreReq: libimobiledevice-devel >= %imobiledevice_ver}
%{?_enable_afp:BuildPreReq: libgcrypt-devel}
%{?_enable_udisks2:BuildPreReq: libudisks2-devel >= %udisks_ver}
%{?_enable_libmtp:BuildPreReq: libmtp-devel >= %mtp_ver}
%{?_enable_goa:BuildPreReq: libgnome-online-accounts-devel >= %goa_ver}
%{?_enable_bluray:BuildPreReq: libbluray-devel}
%{?_enable_systemd_login:BuildPreReq: libsystemd-login-devel}

BuildPreReq: desktop-file-utils
BuildRequires: gcc-c++ perl-XML-Parser

# for check
#BuildRequires: /proc dbus-tools-gui python3 python3-module-pygobject3 python-module-twisted-core
#BuildRequires:  openssh-server apache2 samba genisoimage
# and more

%package devel
Summary: Libraries and include files for developing gvfs applications
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%package -n fuse-gvfs
Summary: gvfs fuse gateway
Group: System/Kernel and hardware
Requires: %name = %version-%release
Requires: %{get_dep fuse}

%package backend-smb
Summary: Samba backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release
Requires: samba-client

%package backend-obexftp
Summary: Obexftp backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-dnssd
Summary: Dnssd(avahi) backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-cdda
Summary: Music CD-ROM backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-afc
Summary: i{Phone,Pod} backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-afp
Summary: Apple Filing Protocol backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-recent-files
Summary: Recent files backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release

%package backend-goa
Summary: gnome-online-accounts backend for gvfs
Group: System/Libraries
Requires: %name = %version-%release
Requires: gnome-online-accounts

%package backend-mtp
Summary: MTP support for gvfs
Group: System/Libraries
Requires: %name = %version-%release


%package backends
Summary: All backends for gvfs
Group: System/Libraries
BuildArch: noarch
Requires: gvfs gvfs-backend-smb gvfs-backend-dnssd
%{?_enable_cdda:Requires: gvfs-backend-cdda}
%{?_enable_obexftp:Requires: gvfs-backend-obexftp}
%{?_enable_afc:Requires: gvfs-backend-afc}
%{?_enable_afp:Requires: gvfs-backend-afp}
%{?_enable_gtk:Requires: gvfs-backend-recent-files}
%{?_enable_goa:Requires: gvfs-backend-goa}
%{?_enable_libmtp:Requires: gvfs-backend-mtp}

%package utils
Summary: Command line applications for gvfs.
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%package -n bash-completion-gvfs
Summary: Bash completion for gvfs utils
Group: Development/Other
BuildArch: noarch
Requires: bash-completion
Requires: gvfs-utils

%description
gvfs is a userspace virtual filesystem where mount runs as a separate
processes which you talk to via dbus. It also contains a gio module that
seamlessly adds gvfs support to all applications using the gio API. It also
supports exposing the gvfs mounts to non-gio applications using fuse.

This package contains the gvfs server, libgvfscommon library, gio
modules and backends for gvfs: archive, burn, computer, dav, ftp,
gphoto2, http, localtest, network, sftp and trash.

%description devel
gvfs is a userspace virtual filesystem where mount runs as a separate
processes which you talk to via dbus. It also contains a gio module that
seamlessly adds gvfs support to all applications using the gio API. It also
supports exposing the gvfs mounts to non-gio applications using fuse.

This package contains the libgvfscommon development files.

%description -n fuse-gvfs
fuse-gvfs is a bridge between the gvfs filesystem design and fuse, a
program to mount user-space filesystems.

%description backend-smb
This package contains the smb and smb-browse backends for gvfs.

%description backend-obexftp
This package contains the obexftp backend for gvfs.

%description backend-dnssd
This package contains the dnssd backend for gvfs.

%description backend-cdda
This package contains the cdda backend for gvfs.

%description backend-afc
This package contains a backend for gvfs, providing access to Apple's
iPhone, and iPod Touch devices.

%description backend-afp
This package contains a backend for gvfs, providing access to Apple
Mac OS X filesystem by AFP (Apple Filing Protocol) network protocol.

%description backend-recent-files
This package contains recent files backend for gvfs.

%description backend-goa
This package contains gnome-online-accounts backend for gvfs.

%description backend-mtp
This package provides support for reading and writing files on MTP based
devices (Media Transfer Protocol) to applications using gvfs.

%description backends
This virtual package contains the all backends for gvfs.

%description utils
This package contains command line tools for gvfs.

%description -n bash-completion-gvfs
Bash completion for gvfs.


%define _libexecdir %_prefix/libexec/%name

%prep
%setup
%patch -p1
%patch1 -p1 -b .archive-integration
%patch3 -p1 -b .headers-install
%patch4 -p1 -b .lfs
%patch5 -b .tmpfiles
%patch6 -p2 -b .logind-state
%patch7 -p1

[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
        %{subst_enable http} \
        %{subst_enable avahi} \
        %{subst_enable cdda} \
        %{subst_enable fuse} \
        %{subst_enable hal} \
        %{subst_enable obexftp} \
        %{subst_enable gphoto2} \
        %{subst_enable keyring} \
        %{subst_enable samba} \
        %{subst_enable archive} \
        %{subst_enable afc} \
        %{subst_enable afp} \
        %{subst_enable gdu} \
        %{subst_enable udisks2} \
        %{subst_enable libmtp} \
        %{subst_enable bluray} \
        %{subst_enable gtk} \
        %{?_enable_systemd_login:--enable-libsystemd-login}
        %{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%make_install install DESTDIR=%buildroot

%find_lang %name

%check
#export PATH=/usr/sbin:$PATH
#%%make check

%post
killall -USR1 gvfsd >&/dev/null || :

%files -f %name.lang
%doc AUTHORS NEWS README monitor/udisks2/what-is-shown.txt
%_libdir/libgvfs*.so.*
%dir %_libexecdir
# daemon
%_libexecdir/gvfsd
%config %_datadir/glib-2.0/schemas/org.gnome.system.gvfs.enums.xml
# monitors
%_libexecdir/gvfs-gphoto2-volume-monitor
%{?_enable_hal:%_libexecdir/gvfs-hal-volume-monitor}
%{?_enable_gdu:%_libexecdir/gvfs-gdu-volume-monitor}
%{?_enable_udisks2:%_libexecdir/gvfs-udisks2-volume-monitor}
%_datadir/dbus-1/services/*
# gio modules
%_libdir/gio/modules/*.so
# default backends
%_libexecdir/gvfsd-*
%exclude %_libexecdir/gvfsd-fuse

%dir %_datadir/%name
%dir %_datadir/%name/remote-volume-monitors
%_datadir/%name/remote-volume-monitors/gphoto2.monitor
%{?_enable_hal:%_datadir/%name/remote-volume-monitors/hal.monitor}
%{?_enable_gdu:%_datadir/%name/remote-volume-monitors/gdu.monitor}
%{?_enable_udisks2:%_datadir/%name/remote-volume-monitors/udisks2.monitor}

%_datadir/%name/mounts
%_datadir/applications/mount-archive.desktop

# in another packages
%if_enabled samba
    %exclude %_libexecdir/gvfsd-smb
    %exclude %_libexecdir/gvfsd-smb-browse
    %exclude %_datadir/%name/mounts/smb.mount
    %exclude %_datadir/%name/mounts/smb-browse.mount
%endif

%{?_enable_cdda:%exclude %_libexecdir/gvfsd-cdda}

%if_enabled obexftp
    %exclude %_libexecdir/gvfsd-obexftp
    %exclude %_datadir/%name/mounts/obexftp.mount
%endif

%if_enabled afc
    %exclude %_libexecdir/gvfsd-afc
    %exclude %_datadir/%name/mounts/afc.mount
%endif

%if_enabled afp
    %exclude %_libexecdir/gvfsd-afp
    %exclude %_libexecdir/gvfsd-afp-browse
    %exclude %_datadir/%name/mounts/afp.mount
    %exclude %_datadir/%name/mounts/afp-browse.mount
%endif

%{?_enable_cdda:%exclude %_datadir/%name/mounts/cdda.mount}
    %exclude %_libexecdir/gvfsd-dnssd
    %exclude %_datadir/%name/mounts/dns-sd.mount

%if_enabled libmtp
    %exclude %_libexecdir/gvfsd-mtp
    %exclude %_datadir/%name/mounts/mtp.mount
    %exclude %_datadir/dbus-1/services/org.gtk.Private.MTPVolumeMonitor.service
%endif

%if_enabled gtk
%exclude %_libexecdir/gvfsd-recent
%exclude %_datadir/%name/mounts/recent.mount
%endif

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
#%%_datadir/gtk-doc/html/*

%files -n fuse-gvfs
%_libexecdir/gvfsd-fuse
/lib/tmpfiles.d/gvfsd-fuse-tmpfiles.conf

%files backend-smb
%_libexecdir/gvfsd-smb
%_libexecdir/gvfsd-smb-browse
%_datadir/%name/mounts/smb.mount
%_datadir/%name/mounts/smb-browse.mount
%config %_datadir/glib-2.0/schemas/org.gnome.system.smb.gschema.xml
%_datadir/GConf/gsettings/gvfs-smb.convert

%if_enabled obexftp
%files backend-obexftp
%_libexecdir/gvfsd-obexftp
%_datadir/%name/mounts/obexftp.mount
%endif

%files backend-dnssd
%_libexecdir/gvfsd-dnssd
%_datadir/%name/mounts/dns-sd.mount
%config %_datadir/glib-2.0/schemas/org.gnome.system.dns_sd.gschema.xml
%_datadir/GConf/gsettings/gvfs-dns-sd.convert

%if_enabled cdda
%files backend-cdda
%_libexecdir/gvfsd-cdda
%_datadir/%name/mounts/cdda.mount
%endif

%if_enabled afc
%files backend-afc
%_libexecdir/gvfsd-afc
%_libexecdir/gvfs-afc-volume-monitor
%_datadir/%name/mounts/afc.mount
%_datadir/%name/remote-volume-monitors/afc.monitor
%endif

%if_enabled afp
%files backend-afp
%_libexecdir/gvfsd-afp
%_libexecdir/gvfsd-afp-browse
%_datadir/%name/mounts/afp.mount
%_datadir/%name/mounts/afp-browse.mount
%endif

%if_enabled gtk
%files backend-recent-files
%_libexecdir/gvfsd-recent
%_datadir/%name/mounts/recent.mount
%endif

%if_enabled goa
%files backend-goa
%_libexecdir/%name-goa-volume-monitor
%_datadir/%name/remote-volume-monitors/goa.monitor
%endif

%if_enabled libmtp
%files backend-mtp
%_libexecdir/gvfsd-mtp
%_libexecdir/gvfs-mtp-volume-monitor
%_datadir/%name/mounts/mtp.mount
%_datadir/%name/remote-volume-monitors/mtp.monitor
%_datadir/dbus-1/services/org.gtk.Private.MTPVolumeMonitor.service
%endif

%files backends

%files utils
%_bindir/*
%_man1dir/*.1.*
%_man7dir/gvfs.7.*

%files -n bash-completion-gvfs
%_datadir/bash-completion/completions/%name

%exclude %_libdir/gio/modules/*.la

%changelog
