%def_disable rpath
%def_with pic
%def_enable deprecated
%def_enable lirc
%def_with dbus
%def_without xinerama
%def_with browser_plugin
%define jstype lib
#----------------------------------------------------------------------
%define subst_with_to() %{expand:%%{?_with_%{1}:--with-%{2}}} %{expand:%%{?_without_%{1}:--without-%{2}}}

Name: gxine
Summary: Mediaplayer - GTK-based GUI for xine libraries
Summary(uk_UA.CP1251):  - GTK+ GUI   xine
Summary(ru_RU.CP1251):  - GTK+ GUI   xine
Version: 0.5.11
Release: alt10.3.qa1
License: %gpl2plus
Group: Video
URL: http://xinehq.de
Source: %name-%version.tar
Patch: gxine-0.5.11-alt-glib2.patch
Patch1: gxine-0.5.11-alt-DSO.patch
Packager: Led <led@altlinux.ru>

BuildRequires(pre): rpm-build-licenses
BuildRequires: imake libgtk+2-devel libxine-devel zlib-devel
BuildRequires: libXtst-devel libXaw-devel libXrandr-devel xorg-cf-files
BuildRequires: libXext-devel xorg-inputproto-devel xorg-sdk
BuildRequires: desktop-file-utils ImageMagick-tools

%{?_enable_lirc:BuildRequires: liblirc-devel}
%{?_with_dbus:BuildRequires: libdbus-glib-devel}
%{?_with_xinerama:BuildRequires: libXinerama-devel}
%{?_with_browser_plugin:BuildRequires: browser-plugins-npapi-devel libnspr-devel}
%{!?jstype:%define jstype moz}
%if %jstype == moz
BuildRequires: xulrunner-devel
%endif
%if %jstype == sea
BuildRequires: seamonkey-devel
%endif
%if %jstype == ff
BuildRequires: firefox-devel
%endif
%if %jstype == lib
BuildRequires: libjs-devel
%endif

%description
%name is a GTK+ based GUI for the libxine video player library.
It provides %name, a  media player that can play all the audio/video
formats that libxine supports. Currently, this includes MPEG1/2, some
AVI and Quicktime files, some network streaming methods and disc based
media (VCD, SVCD, DVD).

%description -l uk_UA.CP1251
%name - GTK+ GUI    libxine.
³  %name - -   / ,
  libxine.     MPEG1/2,   AVI 
Quicktime,        (VCD, SVCD,
DVD).

%description -l ru_RU.CP1251
%name - GTK+ GUI    libxine.
  %name - -  
/ ,  libxine.    
MPEG1/2,   AVI  Quicktime,   
    (VCD, SVCD, DVD).


%package -n mozilla-plugin-%name
Summary: gxine browser plugin
Group: Video
Requires: %name = %version-%release
Requires: browser-plugins-npapi

%description -n mozilla-plugin-%name
Browser plugin for mozilla and other browsers using the same plugin
infrastructure.

%description -n mozilla-plugin-%name -l uk_UA.CP1251
  mozilla       
.

%description -n mozilla-plugin-%name -l ru_RU.CP1251
  mozilla       
.


%prep
%setup
%patch -p0
%patch1 -p0
sed -i \
    -e '/^Encoding=/d' \
    -e '/^Exec=/s/$/ %%U/' \
    -e '/^Categories=/ s/=.*$/=GTK;AudioVideo;Video;Player;TV;/' \
    -e '/^MimeType=/ s|=.*$|='"$(cat %_datadir/mimetypes-devel/libxine)|" \
    %name.desktop
iconv -f cp1251 -t utf-8 >> %name.desktop <<__MENU__
GenericName[ru]= 
GenericName[uk]= 
Comment[ru]=   ,    
Comment[uk]=   ,    
__MENU__


%build
# need for make configure with proper xine.m4
%autoreconf
%configure \
    %{subst_enable rpath} \
    %{subst_with pic} \
    --enable-defeat-screensaver-via-xtest \
    %{subst_enable lirc} \
    --enable-%{jstype}js \
    --with-spidermonkey=%_includedir/js \
    %{subst_with dbus} \
    %{subst_with xinerama} \
    %{subst_with_to browser_plugin browser-plugin} \
    --disable-integration-wizard \
    %{subst_enable deprecated}

%make_build
convert -border 0x8 -bordercolor none -depth 8 pixmaps/%name{,-64}.png
for s in 48 36 32 24 22 16; do
    convert -depth 8 -resize ${s}x$s pixmaps/%name{-64,-$s}.png
done
bzip2 --keep --best --force ChangeLog


%install
%make DESTDIR=%buildroot install
%if_with browser_plugin
install -d %buildroot%browser_plugins_path
mv %buildroot%_libdir/%name/%{name}plugin.* %buildroot%browser_plugins_path/
%endif
for s in 64 48 36 32 24 22 16; do
    install -D -m 0644 {pixmaps/%name-$s,%buildroot%_iconsdir/hicolor/${s}x$s/apps/%name}.png
done
rm -rf %buildroot%_pixmapsdir

%find_lang --with-man %name
%find_lang --with-man --append --output=%name.lang %name.theme
%find_lang --with-man --append --output=%name.lang %{name}_client

%files -f %name.lang
%doc AUTHORS ChangeLog.* README TODO doc/Keybindings-HOWTO
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*
%_bindir/*
%_man1dir/*
%dir %_datadir/%name
%_datadir/%name/*
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*


%if_with browser_plugin
%files -n mozilla-plugin-%name
%browser_plugins_path/*
%endif


%changelog
