%define hdf5dir %_libdir/hdf5-seq
Name: h5py
Version: 2.2.0
Release: alt1.a1.hg20120919
Summary: Python interface to the Hierarchical Data Format library, version 5
License: MIT
Group: Development/Python
Url: http://code.google.com/p/h5py/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# hg clone https://code.google.com/p/h5py/
Source: %name-%version.tar.gz

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel libnumpy-devel libhdf5-devel strace
BuildPreReq: libsz2-devel python-module-Cython python-module-Pyrex
BuildPreReq: python-module-sphinx-devel python-module-Pygments
#BuildPreReq: texlive-latex-recommended

%description
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

%package -n python-module-%name
Summary: Python interface to the Hierarchical Data Format library, version 5
Group: Development/Python
%setup_python_module %name
%py_requires multiprocessing

%description -n python-module-%name
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

%package -n python-module-%name-doc
Summary: Documentation for Python interface to the HDF5
Group: Development/Documentation
BuildArch: noarch

%description -n python-module-%name-doc
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

This package contains development documentation for H5PY.

%package -n python-module-%name-pickles
Summary: Pickles for Python interface to the HDF5
Group: Development/Python

%description -n python-module-%name-pickles
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

This package contains pickles for H5PY.

%package -n python-module-%name-tests
Summary: Tests for Python interface to the HDF5
Group: Development/Python
Requires: python-module-%name = %version-%release

%description -n python-module-%name-tests
HDF5 for Python (h5py) is a general-purpose Python interface to the
Hierarchical Data Format library, version 5. HDF5 is a versatile, mature
scientific software library designed for the fast, flexible storage of
enormous amounts of data.

From a Python programmer's perspective, HDF5 provides a robust way to
store data, organized by name in a tree-like fashion. You can create
datasets (arrays on disk) hundreds of gigabytes in size, and perform
random-access I/O on desired sections. Datasets are organized in a
filesystem-like hierarchy using containers called "groups", and accessed
using the tradional POSIX /path/to/resource syntax.

H5py provides a simple, robust read/write interface to HDF5 data from
Python. Existing Python and Numpy concepts are used for the interface;
for example, datasets on disk are represented by a proxy class that
supports slicing, and has dtype and shape attributes. HDF5 groups are
presented using a dictionary metaphor, indexed by name.

This package contains tests for H5PY.

%prep
%setup

sed -i 's|@PYVER@|%_python_version|g' docs/Makefile

%prepare_sphinx docs

%build
#python setup.py cython
#python setup.py configure --hdf5=%hdf5dir --api=18
pushd %name
python api_gen.py
popd
%add_optflags -fno-strict-aliasing
%python_build_debug --hdf5=%hdf5dir --api=18

%install
%python_install

export PYTHONPATH=%buildroot%python_sitelibdir
pushd docs
%make html
%make pickle
popd

install -d %buildroot%python_sitelibdir/%name/examples
install -p -m644 examples/* %buildroot%python_sitelibdir/%name/examples
touch %buildroot%python_sitelibdir/%name/examples/__init__.py

install -d %buildroot%_docdir/%name
cp -fR docs/build/html lzf %buildroot%_docdir/%name/
#install -m644 docs/build/latex/*.pdf %buildroot%_docdir/%name/pdf

# pickles

cp -fR docs/build/pickle %buildroot%python_sitelibdir/%name/

%files -n python-module-%name
%doc licenses *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/%name/pickle
%exclude %python_sitelibdir/%name/examples
%exclude %python_sitelibdir/*/lowtest
%exclude %python_sitelibdir/*/*/tests

%files -n python-module-%name-doc
%_docdir/%name

%files -n python-module-%name-tests
%python_sitelibdir/*/lowtest
%python_sitelibdir/*/*/tests

%files -n python-module-%name-pickles
%dir %python_sitelibdir/%name
%python_sitelibdir/%name/pickle

%changelog
