%define _libexecdir %_prefix/libexec/hal
%define _haldocdir  %_docdir/lib%name-devel-%version

Name: hal
Version: 0.5.15
Release: alt2
Summary: Hardware Abstraction Layer
Group: System/Servers
License: AFL/GPL
Url: http://www.freedesktop.org/wiki/Software/hal

PreReq: shadow-utils dbus udev
Requires: lib%name = %version-%release dmidecode hal-info >= 20081022-alt5
Conflicts: hal-fstab-sync < 0.0.1-alt7

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch1: hal-0.5.14-alt-ntfs-options.patch
Patch2: hal-0.5.14-alt-v4l.patch
Patch3: hal-0.5.14-alt-glib2.patch
Patch4: hal-0.5.15-udev-direct.patch
Patch5: hal-0.5.15-udevadmin-infoR.patch


AutoReq: yes, noshell
BuildPreReq: libblkid-devel >= 1.43
BuildRequires: docbook-utils gcc-c++ gtk-doc intltool libdbus-glib-devel libudev-devel libexpat-devel libusb-compat-devel perl-XML-Parser
BuildRequires: python-devel gperf python-modules-compiler python-modules-encodings xmlto libConsoleKit-devel libv4l-devel
%ifarch %ix86 x86_64
BuildRequires: libpci-devel zlib-devel
%endif

%description
HAL is daemon for collection and maintaining information from several
sources about the hardware on the system. It provdes a live device
list through D-BUS

%package -n lib%name
Summary: Shared libraries for HAL
Group: System/Libraries
Requires: pciids usbids

%description -n lib%name
This package provides shared libraries for HAL

%package -n lib%name-devel
Summary: Libraries and headers for HAL
Group: Development/C
Requires: lib%name = %version-%release
Obsoletes: %name-devel < %version-%release lib%name-devel-doc < %version-%release
Provides: %name-devel = %version-%release lib%name-devel-doc = %version-%release

%description -n lib%name-devel
Headers for HAL

%prep
%setup -q
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

rm -f gtk-doc.make acinclude.m4

%build
%autoreconf
%configure \
	--disable-static \
	--without-usb-csr \
	--with-cpufreq \
	--disable-docbook-docs \
	--disable-gtk-doc \
	--with-doc-dir=%_haldocdir \
	--with-html-dir=%_haldocdir/api \
	--disable-pmu \
	--disable-policy-kit \
	--with-hal-user=haldaemon \
	--with-hal-group=haldaemon \
	--with-udev-prefix=/lib \
	--with-hwdata=%_datadir/misc \
	--with-pid-file=%_var/run/hal.pid \
	--localstatedir=%_var
%make_build

%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_var/{run,cache}/hald
mkdir -p %buildroot%_sysconfdir/hal/fdi/{information,policy,preprobe}

%pre
%_sbindir/groupadd -r -f haldaemon >/dev/null 2>&1 || :
%_sbindir/useradd -r -g haldaemon -d '/' -s /sbin/nologin -c "HAL daemon" haldaemon >/dev/null 2>&1 ||:

%post
%post_service haldaemon

%preun
%preun_service haldaemon

%files
%doc AUTHORS NEWS README doc/TODO
%_sysconfdir/dbus*/system.d/hal.conf
# /lib/udev/rules.d/90-hal.rules
%_initdir/haldaemon
%dir %_sysconfdir/hal
%dir %_sysconfdir/hal/fdi
%dir %_sysconfdir/hal/fdi/information
%dir %_sysconfdir/hal/fdi/policy
%dir %_sysconfdir/hal/fdi/preprobe
%_sbindir/*
%_bindir/*
%_libexecdir
%dir %_datadir/hal
%_datadir/hal/fdi
%_datadir/hal/scripts
%_man1dir/*.1*
%_man8dir/*.8*
%attr(0775,root,haldaemon) %_var/*/hald

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%changelog
