Name: hiawatha
Version: 9.0
Release: alt1

Summary: A secure and advanced webserver
License: GPLv2+
Group: System/Servers

Url: http://www.hiawatha-webserver.org/
Source: http://www.hiawatha-webserver.org/files/hiawatha-%version.tar.gz
Source1: hiawatha.init
Source2: hiawatha.logrotate
Patch1: hiawatha-6.12-nobody99.patch
Patch2: hiawatha-9.0-libs-in-system-place.patch

BuildRequires(pre): cmake
# Automatically added by buildreq on Mon Mar 28 2011
BuildRequires: libssl-devel libxslt-devel zlib-devel 

%description
Hiawatha is an advanced and secure Web server for Unix. It has been written with
security as its main goal. It's very secure and fast and is really easy to
configure. It features a rootjail, the ability to run CGIs under any UID/GID you
want, prevention of SQL injection and cross-site scripting, banning of clients
who try such exploits, and many other features. These features make Hiawatha an
interesting Web server for those who need more security than what the other
available Web servers are offering.

%prep
%setup
%patch1 -p1
%patch2 -p2

%build
%cmake \
    -DCMAKE_INSTALL_NAME_DIR=%_libdir \
    -DLIB_INSTALL_DIR=%_libdir \
    -DCONFIG_DIR=%_sysconfdir/hiawatha \
    -DWEBROOT_DIR=/var/www/hiawatha
%make_build -C BUILD

%install
%makeinstall_std -C BUILD
install -d %buildroot%_logdir/hiawatha
install -pDm 755 %_sourcedir/hiawatha.init %buildroot%_initrddir/hiawatha
install -pDm 644 %_sourcedir/hiawatha.logrotate %buildroot/etc/logrotate.d/hiawatha

%post
%post_service hiawatha

%preun
%preun_service hiawatha

%files
%dir %_sysconfdir/hiawatha
%config(noreplace) %_sysconfdir/hiawatha/*
%config(noreplace) %_initrddir/hiawatha
%config(noreplace) /etc/logrotate.d/hiawatha
%dir /var/www/hiawatha
%config(noreplace) /var/www/hiawatha/*
%_bindir/ssi-cgi
%_sbindir/cgi-wrapper
%_sbindir/hiawatha
%_sbindir/wigwam
%_libdir/libpolarssl.so*
%_man1dir/*
%_logdir/hiawatha

%changelog
