Epoch: 1
BuildRequires: docbook-xml docbook-dtds
BuildRequires: /proc
BuildRequires: jpackage-compat
# %name or %version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name hibernate3
%define version 3.6.10
%global namedreltag .Final
%global namedversion %{version}%{?namedreltag}
%global oname hibernate-orm

Name: hibernate3
Version: 3.6.10
Release: alt1_6jpp7
Summary: Relational persistence and query service

Group: Development/Java
License: LGPLv2+

URL: http://www.hibernate.org/

# git clone git://github.com/hibernate/hibernate-orm
# cd hibernate-orm/ && git archive --format=tar --prefix=hibernate-orm-3.6.10.Final/ 3.6.10.Final | xz > hibernate-3.6.10.Final.tar.xz
Source0: hibernate-orm-3.6.10.Final.tar.xz
Source1: hibernate3-depmap

Patch0:  hibernate-orm-fix-cglib-gid.patch
Patch1:  hibernate-orm-fix-jacc-gid-aid.patch
Patch2:  hibernate-orm-fix-ant-gid.patch
Patch3:  hibernate-orm-infinispan-5-support.patch

BuildArch: noarch

BuildRequires: jpackage-utils
BuildRequires: maven
BuildRequires: maven-compiler-plugin
BuildRequires: maven-install-plugin
BuildRequires: maven-jar-plugin
BuildRequires: maven-javadoc-plugin
BuildRequires: maven-release-plugin
BuildRequires: maven-resources-plugin
BuildRequires: maven-surefire-plugin
BuildRequires: maven-enforcer-plugin
BuildRequires: geronimo-validation
BuildRequires: maven-injection-plugin
BuildRequires: antlr-maven-plugin
BuildRequires: hibernate-validator
BuildRequires: cglib
BuildRequires: jboss-jacc-1.4-api
BuildRequires: c3p0
BuildRequires: proxool
BuildRequires: hibernate-commons-annotations
BuildRequires: jboss-servlet-3.0-api
BuildRequires: ehcache-core
BuildRequires: jbosscache-core
BuildRequires: jbosscache-common-parent
BuildRequires: infinispan
BuildRequires: rhq-plugin-annotations

Requires: jpackage-utils
Requires: apache-commons-collections
Requires: dom4j
Requires: geronimo-validation
Requires: hibernate-commons-annotations
Requires: hibernate-jpa-2.0-api
Requires: jboss-servlet-3.0-api
Source44: import.info

%description
Hibernate is a powerful, ultra-high performance
object/relational persistence and query service
for Java.

%package javadoc
Summary: API docs for %{name}
Group: Development/Java
Requires: jpackage-utils
BuildArch: noarch

%description javadoc
API documentation for %{name}.

%package entitymanager
Group: Development/Java
Summary: Hibernate Entity Manager
Requires: cglib
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires: hibernate-jpa-2.0-api
Requires: hibernate-validator
Requires: javassist

%description entitymanager
%{summary}.

%package envers
Group: Development/Java
Summary: Hibernate support for entity auditing
Requires: hibernate-commons-annotations
Requires: hibernate-jpa-2.0-api
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires: %{name}-entitymanager = %{?epoch:%epoch:}%{version}-%{release}

%description envers
%{summary}.

%package c3p0
Group: Development/Java
Summary: C3P0-based implementation of Hibernate ConnectionProvider
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires: c3p0

%description c3p0
%{summary}.

%package proxool
Group: Development/Java
Summary: Proxool-based implementation of Hibernate ConnectionProvder
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}

%description proxool
%{summary}.

%package ehcache
Group: Development/Java
Summary: Integration of Hibernate with Ehcache
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires: ehcache-core

%description ehcache
%{summary}.

%package jbosscache
Group: Development/Java
Summary: Integration of hibernate with jbosscache
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires: jbosscache-core

%description jbosscache
%{summary}.

%package infinispan
Group: Development/Java
Summary: Integration of Hibernate with Infinispan
Requires: infinispan

%description infinispan
%{summary}.

%package testing
Group: Development/Java
Summary: Hibernate JUnit test utilities
Requires: %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires: junit

%description testing
%{summary}.

%prep
%setup -q -n %{oname}-%{namedversion}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%pom_remove_plugin org.jboss.maven.plugins:maven-jdocbook-plugin hibernate-parent
%pom_remove_plugin org.jboss.maven.plugins:maven-jdocbook-style-plugin hibernate-parent
%pom_disable_module hibernate-testsuite
%pom_disable_module hibernate-oscache
%pom_disable_module hibernate-swarmcache
%pom_disable_module hibernate-jdbc3-testing
%pom_disable_module hibernate-jdbc4-testing

# disable hibernate-tools support
%pom_remove_dep org.hibernate:hibernate-tools hibernate-envers
%pom_remove_dep ant:ant hibernate-envers
rm -r hibernate-envers/src/main/java/org/hibernate/tool/ant/*.java \
  hibernate-envers/src/main/java/org/hibernate/envers/ant/*.java

# Make hibernate-testing back a test dependency...
sed -i "s|<!-- <scope>test</scope> TODO fix this -->|<scope>test</scope>|" hibernate-infinispan/pom.xml

%build

# Currently 4 tests fail with this error:
# "Unable to get the default Bean Validation factory"
export jdk16_home=/usr
export LANG=en_US.UTF-8
mvn-rpmbuild \
  -Dmaven.local.depmap.file=%{SOURCE1} \
  -DdisableDistribution=true \
  -Dmaven.test.skip=true \
  install \
  javadoc:aggregate


%install

# POM files:
install -d -m 755 %{buildroot}%{_mavenpomdir}
install -pm 644 hibernate-parent/pom.xml  %{buildroot}%{_mavenpomdir}/JPP-%{name}-parent.pom
%add_maven_depmap JPP-%{name}-parent.pom

# Jar files:
install -d -m 755 %{buildroot}%{_javadir}/%{name}
install -m 644 hibernate-core/target/hibernate-core-%{namedversion}.jar %{buildroot}%{_javadir}/%{name}/hibernate-core.jar
install -pm 644 hibernate-core/pom.xml %{buildroot}%{_mavenpomdir}/JPP.%{name}-hibernate-core.pom
%add_maven_depmap JPP.%{name}-hibernate-core.pom %{name}/hibernate-core.jar

for module in c3p0 ehcache infinispan jbosscache proxool \
              entitymanager envers testing; do
    install -m 644 hibernate-${module}/target/hibernate-${module}-%{namedversion}.jar %{buildroot}%{_javadir}/%{name}/hibernate-${module}.jar
    install -pm 644 hibernate-${module}/pom.xml %{buildroot}%{_mavenpomdir}/JPP.%{name}-hibernate-${module}.pom
%add_maven_depmap JPP.%{name}-hibernate-${module}.pom %{name}/hibernate-${module}.jar -f ${module}
done

# Javadoc files:
install -d -m 755 %{buildroot}%{_javadocdir}/%{name}
cp -rp target/site/apidocs/* %{buildroot}%{_javadocdir}/%{name}
# compat symlink
ln -s hibernate3/hibernate-core.jar %buildroot%_javadir/hibernate3.jar

%files
%_javadir/hibernate3.jar
%doc changelog.txt lgpl.txt
%dir %{_javadir}/%{name}
%{_javadir}/%{name}/hibernate-core.jar
%{_mavenpomdir}/JPP-%{name}-parent.pom
%{_mavenpomdir}/JPP.%{name}-hibernate-core.pom
%{_mavendepmapfragdir}/%{name}

%files javadoc
%doc lgpl.txt
%{_javadocdir}/%{name}

%files entitymanager
%{_javadir}/%{name}/hibernate-entitymanager.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-entitymanager.pom
%{_mavendepmapfragdir}/%{name}-entitymanager

%files envers
%{_javadir}/%{name}/hibernate-envers.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-envers.pom
%{_mavendepmapfragdir}/%{name}-envers

%files c3p0
%{_javadir}/%{name}/hibernate-c3p0.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-c3p0.pom
%{_mavendepmapfragdir}/%{name}-c3p0

%files ehcache
%{_javadir}/%{name}/hibernate-ehcache.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-ehcache.pom
%{_mavendepmapfragdir}/%{name}-ehcache

%files infinispan
%{_javadir}/%{name}/hibernate-infinispan.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-infinispan.pom
%{_mavendepmapfragdir}/%{name}-infinispan

%files proxool
%{_javadir}/%{name}/hibernate-proxool.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-proxool.pom
%{_mavendepmapfragdir}/%{name}-proxool

%files jbosscache
%{_javadir}/%{name}/hibernate-jbosscache.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-jbosscache.pom
%{_mavendepmapfragdir}/%{name}-jbosscache

%files testing
%{_javadir}/%{name}/hibernate-testing.jar
%{_mavenpomdir}/JPP.%{name}-hibernate-testing.pom
%{_mavendepmapfragdir}/%{name}-testing

%changelog
