# -*- mode: rpm-spec; coding: utf-8 -*-
%def_with menu

Name: icewm
Version: 1.3.8
Release: alt3.M70T.1
Epoch: 2

Summary: X11 Window Manager
Group: Graphical desktop/Icewm
License: LGPLv2
Url: http://www.icewm.org/
Packager: Dmitriy Khanzhin <jinn@altlinux.ru>

Source: %name-%version.tar
Source1: %name.menu
Source2: %name.menu-method
Source3: %name-16.png
Source4: %name-32.png
Source5: %name-48.png
Source6: start%name
Source7: IceWM.xpm
Source8: %name.wmsession
Source9: %name.alternatives
Source11: README.ALT
Source12: %name.desktop
Source13: restart

Patch0:  %name-multibyte.patch
Patch1:  %name-alt-altconf.patch
Patch2:  %name-alt-fonts.patch
Patch3:  %name-alt-icons.patch
Patch4:  %name-alt-findicon.patch
Patch5:  %name-deb-alt-i18n_update.patch
Patch6:  %name-alt-cpustatus.patch
Patch7:  %name-alt-taskbar.patch
Patch8:  %name-1.3.7-trayicons.patch
Patch9:  %name-build_fixes.patch
Patch10: %name-1.3.8-stronger_control_in_icewm-session.patch

PreReq: %name-light = %epoch:%version-%release

Conflicts: icewm-githubmod

# Automatically added by buildreq on Sun May 20 2012
BuildRequires: gcc-c++ imake libSM-devel libXext-devel libXft-devel libXinerama-devel libXrandr-devel libgdk-pixbuf-devel mkfontdir xorg-cf-files

%if_without menu
BuildPreReq: desktop-file-utils
%endif

%description
Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.

Recommends: iftop, mutt

%package light
Summary: A light version of Icewm
Group: Graphical desktop/Icewm
Requires: design-%name >= 1.0-alt6
Conflicts: icewm-githubmod

%description light
Window Manager for X Window System. Can emulate the look of Windows'95, OS/2
Warp 3,4, Motif or the Java Metal GUI. Tries to take the best features of the
above systems. Features multiple workspaces, opaque move/resize, task bar,
window list, mailbox status, digital clock. Fast and small.

Recommends: iftop, mutt

%prep
%setup

%patch0  -p2
%patch1  -p2
%patch2  -p2
%patch3  -p2
%patch4  -p2
%patch5  -p2
%patch6  -p2
%patch7  -p2
%patch8  -p2
%patch9  -p2
%patch10 -p2

%add_optflags %optflags_nocpp

%build

./autogen.sh
%configure \
	--sysconfdir=%_sysconfdir/X11 \
	--with-cfgdir=%_sysconfdir/X11/%name \
	--with-libdir=%_x11x11dir/%name \
	--enable-nls \
	--enable-i18n \
	--disable-shaped-decorations \
	--disable-gradients \
	--disable-taskbar \
	--enable-lite
%make_build
cp src/%name src/%name-light

make distclean

%configure \
	--sysconfdir=%_sysconfdir/X11 \
	--with-cfgdir=%_sysconfdir/X11/%name \
	--with-libdir=%_x11x11dir/%name \
	--enable-nls \
	--enable-i18n \
	--enable-antialiasing \
	--enable-shaped-decorations \
	--enable-gradients \
	--enable-guievents

touch src/Makefile
%make_build
cp -p src/%name src/%name-full

%install
%make_install \
	BINDIR=%buildroot%_bindir \
	LIBDIR=%buildroot%_x11x11dir/%name \
	ETCDIR=%buildroot%_sysconfdir/X11/%name \
	DOCDIR=%buildroot%_docdir \
	LOCDIR=%buildroot%_datadir/locale \
	install

rm -f %buildroot%_bindir/%name
install src/%name-light %buildroot%_bindir/
install src/%name-full %buildroot%_bindir/

%if_with menu
mkdir -p %buildroot%_menudir
install -m 644 %SOURCE1 %buildroot%_menudir/%name
%endif
mkdir -p %buildroot%_sysconfdir/menu-methods
install -m 755 %SOURCE2 %buildroot%_sysconfdir/menu-methods/%name

install -pD -m644 %SOURCE3 %buildroot%_miconsdir/%name.png
install -pD -m644 %SOURCE4 %buildroot%_niconsdir/%name.png
install -pD -m644 %SOURCE5 %buildroot%_liconsdir/%name.png
install -pD -m644 %SOURCE7 %buildroot%_pixmapsdir/IceWM.xpm
install -pD -m644 %SOURCE8 %buildroot%_sysconfdir/X11/wmsession.d/04IceWM
install -pD -m644 %SOURCE9 %buildroot%_altdir/%name
install -m 644 %SOURCE11 doc/README.ALT

mkdir -p %buildroot%_sysconfdir/X11/%name

mv %buildroot%_x11x11dir/%name/{menu,preferences,keys,toolbar,winoptions} %buildroot%_sysconfdir/X11/%name/

install -m 755 %SOURCE6 %buildroot%_bindir/start%name
install -m 755 %SOURCE13 %buildroot%_sysconfdir/X11/%name/restart

%if_without menu
desktop-file-install --vendor alt --dir %buildroot%_desktopdir %SOURCE12
%endif

%find_lang  %name

# remove unpackaged files
rm -f %buildroot/%_bindir/%name-set-gnomewm
rm -rf %buildroot/%_x11x11dir/%name/themes/*

%files
%_bindir/%name-full
#_bindir/icesound
%_bindir/icesh
%_bindir/icehelp
%_bindir/%{name}hint
%_x11x11dir/%name/icons/*
%exclude %_x11x11dir/%name/icons/app*
%exclude %_x11x11dir/%name/icons/xterm*

%doc README CHANGES TODO BUGS AUTHORS %name.lsm  doc/*.html doc/%name.sgml doc/README*

%files light -f %name.lang
%config(noreplace) %_sysconfdir/menu-methods/*
%_sysconfdir/X11/wmsession.d/*
%_altdir/%name
%_bindir/%name-light
%_bindir/%name-session
%_bindir/start%name
%_bindir/%{name}tray
%_bindir/%{name}bg
%dir %_x11x11dir/%name
%_x11x11dir/%name/mailbox
%dir %_sysconfdir/X11/%name
%ghost %config(noreplace) %_sysconfdir/X11/%name/menu
%config(noreplace) %_sysconfdir/X11/%name/preferences
%config(noreplace) %_sysconfdir/X11/%name/restart
%config(noreplace) %_sysconfdir/X11/%name/toolbar
%config(noreplace) %_sysconfdir/X11/%name/keys
%config(noreplace) %_sysconfdir/X11/%name/winoptions
%_x11x11dir/%name/taskbar
%_x11x11dir/%name/ledclock
%dir %_x11x11dir/%name/icons
%dir %_x11x11dir/%name/themes
%_x11x11dir/%name/icons/app*
%_x11x11dir/%name/icons/xterm*
%if_with menu
%_menudir/*
%else
%_desktopdir/*
%endif
%_niconsdir/*
%_miconsdir/*
%_liconsdir/*
%_pixmapsdir/*

%changelog
