%define theme oxygen

Name: icon-theme-%theme
Version: 4.12.3
Release: alt1

Summary: A set of Icons for KDE
Group: Graphics
Url: http://www.oxygen-icons.org/
License: LGPL

BuildArch: noarch

Provides: kde4-%name = %version-%release
Provides: kde4-icon-theme = %version-%release
Conflicts: kde4libs < 4.2.60

Source: %theme-icons-%version.tar
Source10: exclude.txt
Patch1: oxygen-icons-4.11.1-alt-defaults.patch

BuildRequires: cmake gcc-c++ kde-common-devel
BuildRequires: icon-naming-utils

%description
A set of Icons for KDE

%prep
%setup -qn %theme-icons-%version
%patch1 -p1

%build
%K4build

%install
%K4install

#5707
pushd %buildroot/%_iconsdir/%theme
for sz in 16x16 22x22 32x32 48x48 64x64 128x128 256x256
do
    if [ -d $sz ]; then
	pushd $sz
	for ctx in `ls -1`; do
	    [ -d $ctx ] \
		&& %_libexecdir/icon-name-mapping -c $ctx
	done
	popd
    fi
done
popd

# fix broken symlinks
find %buildroot/%_iconsdir/%theme -type l | \
while read l
do
    POINTS_TO=`readlink $l`
    FILENAME_TO=${POINTS_TO##*/}
    if [ "$POINTS_TO" != "$FILENAME_TO" ] ; then
	DIRPATH=`dirname $l`
	if [ -e "$DIRPATH/$FILENAME_TO" ] ; then
	    ln -snf "$FILENAME_TO" $l
	else
	    rm -f $l
	fi
    else
	continue
    fi
done


>exlude-list
while read ex
do
    [ -e %buildroot$ex ] \
	&& echo "%%exclude $ex" >> exlude-list
done < %SOURCE10


%files -f exlude-list
%doc AUTHORS COPYING CONTRIBUTING
#
%dir %_iconsdir/%theme
%_iconsdir/%theme/index.*
%_iconsdir/%theme/?x?
%_iconsdir/%theme/??x??
%_iconsdir/%theme/???x???

%changelog
