Name: icu56
Version: 5.6.1
Release: alt0.M70P.1
Epoch: 1

Summary: International Components for Unicode
Group: System/Libraries
License: X License
URL: http://www.icu-project.org/

Source: http://download.icu-project.org/files/icu4c/56.1/icu4c-56_1-src.tgz
# fc
Patch1: icu.8198.revert.icu5431.patch
Patch2: icu.8800.freeserif.crash.patch
Patch3: icu.7601.Indic-ccmp.patch
Patch4: gennorm2-man.patch
Patch5: icuinfo-man.patch
Patch6: armv7hl-disable-tests.patch
Patch7: use-old-autoconf.patch

BuildRequires: doxygen gcc-c++ libstdc++-devel

%set_debuginfo_skiplist /*
%define libicu libicu56

%description
ICU is a C++ and C library that provides robust and full-featured Unicode
support

%package utils
Summary: International Components for Unicode (utilities)
Group: Text tools
Requires: %libicu = %epoch:%version-%release
Conflicts: icu-utils

%description utils
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the utilites for compiling and developing
programs with ICU

%package -n %libicu
Summary: International Components for Unicode (libraries)
Group: System/Libraries

%description -n %libicu
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the runtime libraries for ICU

%package -n %libicu-devel
Summary: International Components for Unicode (development files)
Group: Development/C++
Requires: %libicu = %epoch:%version-%release
Requires: %name-utils = %epoch:%version-%release
Conflicts: libicu-devel

%description -n %libicu-devel
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the development files for ICU

%prep
%setup -n icu
%patch1 -p2 -R -b .icu8198.revert.icu5431.patch
%patch2 -p1 -b .icu8800.freeserif.crash.patch
%patch3 -p1 -b .icu7601.Indic-ccmp.patch
%patch4 -p1 -b .gennorm2-man.patch
%patch5 -p1 -b .icuinfo-man.patch
%ifarch armv7hl
%patch6 -p1 -b .armv7hl-disable-tests.patch
%endif
%patch7 -p2

%build
cd source
%autoreconf -I config/m4
%configure \
	--disable-samples \
	--disable-static
%make_build

%install
cd source
%makeinstall_std
cp -a samples %buildroot%_datadir/icu
rm -f %buildroot%_bindir/icuinfo

%files utils
%_bindir/*
%exclude %_bindir/icu-config
%_sbindir/*
%exclude %_man1dir/icu-config.1*
%_man1dir/*
%_man8dir/*

%files -n %libicu
%doc *.html *.css
%_libdir/*.so.*

%files -n %libicu-devel
%_includedir/*
%_bindir/icu-config
%_libdir/*.so
%_libdir/icu
%_pkgconfigdir/*.pc
%_datadir/icu
%exclude %_datadir/icu/samples
%_man1dir/icu-config.1*

%changelog
