Name: imlib
Version: 1.9.15
Release: alt5

Summary: An image loading and rendering library for X11R6
License: LGPL
Group: System/Libraries

Url: http://freshmeat.net/projects/imlib
Source0: ftp://ftp.gnome.org/pub/GNOME/sources/imlib/1.9/imlib-%version.tar.bz2
Source1: imlib-pofiles.tar.bz2
Source2: http://cvs.pld-linux.org/cgi-bin/cvsweb/packages/imlib/imlib-config.desktop
Patch1: imlib-1.9.14-mdk-rh-m4.patch
Patch2: imlib-1.9.14-alt-imlib_config-i18n.patch
Patch3: imlib-1.9.14-alt-path.patch
Patch4: imlib-1.9.15-alt-configure.patch
Patch5: imlib-1.9.14-alt-linkage.patch
Patch6: imlib-1.9.14-peak-fixes.patch
Patch7: imlib-1.9.14-alt-gdk_imlib-modules-debug.patch
Patch8: imlib-1.9.15-debian-shm.patch
Patch9: imlib-1.9.15-asneeded.patch
Patch10: imlib-1.9.15-alt-DSO.patch
Patch11: imlib-1.9.15-alt-libpng15.patch

Provides: lib%name = %version-%release
Obsoletes: Imlib, lib%name

%def_disable static

# Automatically added by buildreq on Sat Jun 06 2009
BuildRequires: gtk+-devel libSM-devel libXext-devel libgif-devel libjpeg-devel libpng-devel libtiff-devel

%package cfgeditor
Summary: A configuration editor for the Imlib library
Group: System/Libraries
Requires: %name = %version-%release

%package devel
Summary: Includes and other files to develop imlib applications
Group: Development/GNOME and GTK+
Requires: %name = %version-%release, %name-cfgeditor = %version-%release
Requires: gtk+-devel libSM-devel libXext-devel libjpeg-devel libpng-devel libtiff-devel libungif-devel
Provides: lib%name-devel = %version-%release
Obsoletes: lib%name-devel

%package devel-static
Summary: Static library files to develop imlib applications
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release, libpng3-devel-static
Provides: lib%name-devel-static = %version-%release
Obsoletes: lib%name-devel-static

%description
Imlib is a display depth independent image loading and rendering library.
Imlib is designed to simplify and speed up the process of loading images
and obtaining X Window System drawables.  Imlib provides many simple
manipulation routines which can be used for common operations.

%description cfgeditor
The imlib-cfgeditor package contains the %{name}_config program, which
you can use to configure the Imlib image loading and rendering library.
Imlib_config can be used to control how Imlib uses color and handles
gamma corrections, etc.

%description devel
The header files, static libraries and documentation needed for developing
Imlib applications.  Imlib is an image loading and rendering library
for X11R6.

%description devel-static
The static libraries needed to link Imlib applications statically
with Imlib.  Imlib is an image loading and rendering library for X11R6.

%prep
%setup -a1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%{?_enable_debug:%patch7 -p1}
%patch8 -p1
%patch9 -p0
%patch10 -p2
%patch11 -p2

%build
%autoreconf
%add_optflags -DENABLE_NLS
export \
	ac_cv_lib_dnet_dnet_ntoa=no \
	ac_cv_path_CJPEG_PROG=%_bindir/cjpeg \
	ac_cv_path_DJPEG_PROG=%_bindir/djpeg \
	ac_cv_path_CONVERT_PROG=%_bindir/convert \
	ac_cv_path_GIFTOPNM_PROG=%_bindir/giftopnm \
	#
%configure %{subst_enable static}
#SMP-incompatible build
%make
# Compile locales by hand.
pushd po
	for f in *.po; do
		msgfmt -v -o "${f%%.po}.mo" "$f"
	done
popd

%install
%makeinstall

# Install locales by hand.
pushd po
	for f in *.mo; do
		install -pD -m644 "$f" "%buildroot%_datadir/locale/${f%%.mo}/LC_MESSAGES/imlib.mo"
	done
popd

install -pD -m644 %SOURCE2 %buildroot%_desktopdir/imlib-config.desktop

%define docdir %_docdir/%name-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 README AUTHORS ChangeLog doc/*.{gif,html} \
	%buildroot%docdir/
bzip2 -9 %buildroot%docdir/ChangeLog

%find_lang imlib

%files
%_libdir/*.so.*
%_libdir/libimlib-*.so
%config(noreplace) %_sysconfdir/*
%dir %docdir
%docdir/[AR]*

%files cfgeditor -f imlib.lang
%_bindir/*_config
%_man1dir/*_config.*
%_desktopdir/imlib-config.desktop

%files devel
%_bindir/*-config
%_man1dir/*-config.*
%_libdir/libImlib.so
%_libdir/libgdk_imlib.so
%_includedir/*
%_libdir/pkgconfig/*.pc
%_datadir/aclocal/*
%dir %docdir
%docdir/C*
%docdir/*.gif
%docdir/*.html

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
