%define shortname indi

%add_verify_elf_skiplist %_libdir/libindidriver.so.*
%add_verify_elf_skiplist %_libdir/libindimain.so.*

Name: indilib
Version: 0.9.6
Release: alt0.M70P.1

Group: Development/C
Summary: Library to control astronomical devices
Url: http://indi.sourceforge.net/
License: LGPLv2+

Provides: %shortname = %version-%release
Conflicts: kde4edu-kstars < 4.1.60
Conflicts: kdeedu-kstars <= 3.5.10-alt2

Source: http://nchc.dl.sourceforge.net/sourceforge/indi/lib%{shortname}_%version.tar.gz
# SuSE
Patch1: no-return-in-nonvoid-function.patch
Patch2: udev_rules_dir_configurable.patch

# Automatically added by buildreq on Wed Oct 05 2011 (-bi)
# optimized out: cmake-modules elfutils libstdc++-devel pkg-config zlib-devel
#BuildRequires: boost-devel-headers cmake gcc-c++ libcfitsio-devel libnova-devel libusb-compat-devel zlib-devel-static
BuildRequires: boost-devel cmake gcc-c++ libcfitsio-devel libnova-devel libusb-compat-devel zlib-devel
BuildRequires: kde-common-devel

%description
INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).

%package -n libsbigudrv
Summary: Librar file for INDI
Group: Development/C
%description -n libsbigudrv
  INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).
  This package contains library files of indilib.

%package -n lib%shortname
Group: System/Libraries
Summary: Library to control astronomical devices
%description -n lib%shortname
INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).

%package -n lib%shortname-devel
Summary: INDI devellopment files
Group: Development/C
Requires: lib%shortname = %version-%release
Provides: %shortname-devel = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < %version-%release
%description -n lib%shortname-devel
  INDI is an instrument neutral distributed interface control protocol
that aims to provide backend driver support and automation for a wide
range of Astronomical devices (telescopes, focusers, CCDs..etc).
  This package contains files need to build applications using indilib.

%prep
%setup -q -n lib%{shortname}_%version
%patch1 -p1
%patch2 -p0

%build
%Kbuild \
    -DUDEVRULES_INSTALL_DIR=%_udevrulesdir \
    #

%install
%Kinstall


%files
%doc ChangeLog NEWS README TODO
%_bindir/*
%_datadir/%shortname
%_udevrulesdir/*.rules

%files -n lib%shortname
%doc ChangeLog NEWS README TODO
%_libdir/lib*.so.*

#%files -n libsbigudrv
#%_libdir/libsbigudrv.so.*

%files -n lib%shortname-devel
%doc ChangeLog README.*
#%doc src/examples
%_libdir/*.so
%_libdir/*.a
%_includedir/libindi
%_pkgconfigdir/libindi.pc

%changelog
