%define pre %nil
Name: inkscape
Version: 0.48.4
Release: alt4.M70P.1

Summary: A Vector Drawing Application

License: GPL
Group: Graphics
Url: http://inkscape.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://prdownloads.sf.net/%name/%name-%version%pre.tar

#Source1: %name-%version.ru.po
Source2: tutorial-%version.tar

Patch: %name.patch

# Typical environment for GTK program
Requires(post,postun): desktop-file-utils
#BuildPreReq: menu-devel
BuildPreReq: desktop-file-utils

%add_findreq_skiplist %_datadir/%name/extensions/*

# manually removed: bzr
# Automatically added by buildreq on Sat Aug 04 2012
# optimized out: fontconfig fontconfig-devel glib2-devel gnome-vfs libGConf-devel libX11-devel libatk-devel libatkmm-devel libavahi-glib libcairo-devel libcairomm-devel libdbus-glib libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libglibmm-devel libgpg-error libgtk+2-devel libp11-kit libpango-devel libpangomm-devel libpng-devel libpoppler-devel libpoppler8-glib libsigc++2-devel libstdc++-devel libwpd9-devel libxml2-devel perl-Encode perl-XML-Parser pkg-config python-base python-devel python-module-distribute python-module-peak python-module-zope python-modules xorg-xproto-devel zlib-devel
BuildRequires: boost-devel-headers gcc-c++ gnome-vfs-devel intltool libImageMagick-devel libaspell-devel libgc-devel libgsl-devel libgtkmm2-devel libgtkspell-devel liblcms-devel libpoppler-glib-devel libpopt-devel libwpg2-devel libxslt-devel perl-devel python-module-mwlib python-module-paste

BuildRequires: libpng-devel
BuildRequires: libpoppler-devel

Requires: icc-profiles

# For extensions
# It is recommended to install skencil, pstoedit also
# https://bugzilla.altlinux.org/21626
Requires: wmf-utils python-module-lxml

# mike: work around https://bugzilla.altlinux.org/24586
Requires: gnome-icon-theme

%description
Inkscape is a SVG based generic vector-drawing program for Linux/Unix
and Windows.  It uses an advanced imaging engine with anti-aliased
display, alpha transparency, and vector fonts.

%description -l ru_RU.UTF-8
Inkscape -- это программа векторного рисования общего назначения,
использующая формат SVG, работающая на платформах Linux/Unix/Windows
и имеющая мощный движок для отображения графики со сглаживанием,
альфа-каналом и векторными шрифтами.

%package viewer
Summary: Viewer for Inkscape files
Group: Graphics

%description viewer
inkview is standalone viewer for Inkscape files (SVG)

%prep
%setup -n %name-%version%pre
%patch

#cat %%SOURCE1 >po/ru.po

%build
%add_optflags -fpermissive
%autoreconf
subst "s|.*\(checkPYTHON_LIBS\)=.*|\1=-lpython%_python_version|" ./configure
%configure \
        --with-gnome-vfs        \
        --with-python           \
        --with-perl             \
        --with-xft              \
        --enable-lcms           \
        --enable-poppler-cairo
%make_build

%install
%makeinstall_std

# use tango by default (bug #13994)
#cp share/icons/tango_icons.svg %buildroot%_datadir/%name/icons/icons.svg

tar xvf %SOURCE2 -C %buildroot%_datadir/inkscape/tutorials/

# remove unneeded man
rm -rf %buildroot%_mandir/fr/
rm -rf %buildroot%_mandir/el/
rm -rf %buildroot%_mandir/ja/
rm -rf %buildroot%_mandir/sk/
rm -rf %buildroot%_mandir/zh_TW/

%find_lang %name

#%check
#$(INKSCAPE) -z -f $< --export-eps=$@
#$(INKSCAPE) -z -f $< --export-png=$@
#true

%files -f %name.lang
%doc AUTHORS COPYING COPYING.LIB ChangeLog NEWS README doc
%_bindir/inkscape
%_datadir/%name/
%_desktopdir/inkscape.desktop
%_iconsdir/hicolor/*/apps/%name.png
%_man1dir/inkscape*

%files viewer
%_bindir/inkview
%_man1dir/inkview*

%changelog
