Name: inn
Version: 2.4.5
Release: alt5

Summary: The InterNetNews (INN) system, an Usenet news server
License: GPL
Group: System/Servers

Url: http://www.isc.org/products/INN
Packager: Vladimir V Kamarzin <vvk@altlinux.ru>

# ftp://ftp.isc.org/isc/inn/inn-2.4.3.tar.gz
Source0: %name-%version.tar
Source1: %name-default-active
Source2: %name-default-distributions
Source3: %name-default-newsgroups
Source4: %name-cron-expire
Source5: %name-cron-rnews
Source6: %name-etc-nnrp.access
Source7: %name-cron-nntpsend
Source8: innd.init
# ftp://ftp.exit109.com/users/jeremy/cleanfeed-latest.tar.bz2
Source9: cleanfeed-latest.tar
# ftp://ftp.isc.org/pub/pgpcontrol/pgpverify-1.2.1
Source10: pgpverify-1.2.1
Source11: %name-faq.tar

BuildPreReq: autoconf = 2.13
Requires: lib%name = %version-%release

# Automatically added by buildreq on Mon Dec 12 2005 (-bi)
BuildRequires: ctags flex gnupg libdb4-devel libe2fs-devel
BuildRequires: libkrb5-devel libpam-devel libssl-devel ncompress
BuildRequires: perl-Math-BigInt perl-devel perl-libnet python-base
BuildRequires: python-modules-compiler python-modules-encodings su tcl time uucp
BuildRequires: wget

%description
INN (InterNetNews) is a complete system for serving Usenet news and/or
private newsfeeds.  INN includes innd, an NNTP (NetNews Transport
Protocol) server, and nnrpd, a newsreader that is spawned for each client.
Both innd and nnrpd vary slightly from the NNTP protocol, but not in ways
that are easily noticed.

Install the inn package if you need a complete system for serving and
reading Usenet news.  You may also need to install inn-devel, if you are
going to use a separate program which interfaces to INN, like newsgate or
tin.

!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!
!!! ATTENTION !!!                                                     !!! ATTENTION !!!
!!! ATTENTION !!!        THIS PACKAGE IS COMPLETELY INSECURE.         !!! ATTENTION !!!
!!! ATTENTION !!! DON'T INSTALL IT UNLESS YOU DON'T CARE OF SECURITY. !!! ATTENTION !!!
!!! ATTENTION !!!                                                     !!! ATTENTION !!!
!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!

%package -n lib%name-devel
Summary: The INN (InterNetNews) development header files and libraries
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
The inn-devel package contains the INN (InterNetNews) library, which
several programs that interface with INN need in order to work (for
example, newsgate and tin).

%package -n lib%name-devel-static
Summary: The INN (InterNetNews) development static libraries.
Group: Development/Other
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
The inn-devel package contains the INN (InterNetNews) static library,
which several programs that interface with INN need in order to work
(for example, newsgate and tin).

%package -n lib%name
Summary: The shared libraries required for inn server.
Group: System/Libraries

%description -n lib%name
The inn-libs package provides the essential shared libraries for inn server.
You will need to install this package to use inn package or any clients that
need to connect to a inn server.

%package -n inews
Summary: Sends Usenet articles to a local news server for distribution
Group: System/Servers
Requires: lib%name = %version-%release

%description -n inews
The inews program is used by some news programs (for example, inn and
trn) to post Usenet news articles to local news servers.  Inews reads an
article from a file or standard input, adds headers, performs some
consistency checks and then sends the article to the local news server
specified in the inn.conf file.

Install inews if you need a program for posting Usenet articles to local
news servers.

%prep
%setup -q -a9 -a11

%build
%set_autoconf_version 2.13

# [hack]: fix path to -ldb
sed -i -e "s,@BERKELEY_DB_LDFLAGS@,-L%_libdir,g" Makefile.global.in
rm -f config.cache
autoconf
export CFLAGS="%optflags %optflags_shared"

./configure %_target_platform \
	--prefix=%prefix  \
	--sysconfdir=%_sysconfdir/news \
	--mandir=%_mandir \
	--with-log-dir=%_logdir/inn \
	--with-syslog-dir=%_logdir/news \
	--with-spool-dir=%_spooldir/news\
	--with-db-dir=%_localstatedir/news \
	--with-run-dir=%_var/run/news \
	--with-etc-dir=%_sysconfdir/news \
	--with-tmp-dir=%_var/run/news/tmp \
	--with-control-dir=%_libdir/%name/control \
	--with-filter-dir=%_sysconfdir/news/filter \
	--with-auth-dir=%_libdir/%name/auth \
	--with-rnews-dir=%_libdir/%name/rnews.libexec \
	--with-lib-dir=%_libdir \
	--with-newslib-dir=%_libdir/%name \
	--with-berkeleydb \
	--enable-libtool \
	--enable-shared \
	--with-perl \
	--with-openssl \
	--with-kerberos \
	--enable-largefiles \
	--enable-pgp-verify \
	--enable-merge-to-groups \
	--with-news-user=news \
	--with-news-group=news \
	--with-news-master=news \
	--with-sendmail=%_sbindir/sendmail

#NO SMP
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make

%install
%make install DESTDIR=%buildroot

# -- Install man pages needed by suck et al.
#for f in clibrary.h config.h dbz.h libinn.h storage.h; do
#	install -pD -m644 ./include/$f "$RPM_BUILD_ROOT%_includedir/%name/$f"
#done

touch %buildroot%_localstatedir/news/subscriptions
chmod 644 %buildroot%_localstatedir/news/subscriptions

#install -m 644 $RPM_SOURCE_DIR/inn-default-active \
#        %buildroot%_localstatedir/news/active
install -m 644 $RPM_SOURCE_DIR/inn-default-distributions \
        %buildroot%_localstatedir/news/distributions
install -m 644 $RPM_SOURCE_DIR/inn-default-newsgroups \
        %buildroot%_localstatedir/news/newsgroups

mkdir -p %buildroot%_sysconfdir/cron.hourly %buildroot%_sysconfdir/cron.daily
install -m755 $RPM_SOURCE_DIR/inn-cron-expire \
        %buildroot%_sysconfdir/cron.daily/inn-cron-expire
install -m755 $RPM_SOURCE_DIR/inn-cron-rnews \
        %buildroot%_sysconfdir/cron.hourly/inn-cron-rnews
install -m755 $RPM_SOURCE_DIR/inn-cron-nntpsend \
        %buildroot%_sysconfdir/cron.hourly/inn-cron-nntpsend

install -m440 $RPM_SOURCE_DIR/inn-etc-nnrp.access \
        %buildroot%_sysconfdir/news/nnrp.access

mkdir -p %buildroot%_initdir
install -m 755 %SOURCE8 \
	%buildroot%_initdir/innd

rm -f %buildroot%_localstatedir/news/history
touch %buildroot%_localstatedir/news/history
chmod 644 %buildroot%_localstatedir/news/*

#Fix perms in sample directory to avoid bogus dependencies
find samples -name "*.in" -exec chmod a-x {} \;

mkdir -p %buildroot%_spooldir/news/articles
mkdir -p %buildroot%_spooldir/news/overview
mkdir -p %buildroot%_spooldir/news/archive
mkdir -p %buildroot%_spooldir/news/incoming/bad
mkdir -p %buildroot%_spooldir/news/outgoing
mkdir -p %buildroot%_spooldir/news/uniover
mkdir -p %buildroot%_spooldir/news/innfeed
mkdir -p %buildroot%_logdir/inn
mkdir -p %buildroot%_var/run/news/tmp

%post
#if [ `%__cat %_sysconfdir/news/inn.conf | %__grep '^server:' | wc -l` -lt 1 ]; then
#  echo "server: `hostname -f`" >> %_sysconfdir/news/inn.conf
#fi

%post_service innd

%preun
%preun_service innd
if [ -f %_localstatedir/news/history.dir ]; then
	rm -f %_localstatedir/news/history.*
fi

# fix default filter path change introduced in 2.4.5-alt3
%triggerun -- inn =< 2.4.5-alt3
if [ "$2" -eq 0 ]; then
	sed -i -e "s,\(^pathfilter:[ \t]*\)%_libdir/%name/filter,\1%_sysconfdir/news/filter," \
		%_sysconfdir/news/inn.conf
fi

%files
%doc samples README* ChangeLog CONTRIBUTORS LICENSE INSTALL faq NEWS TODO 
%doc doc/checklist doc/compliance-nntp doc/config-design doc/config-semantics doc/config-syntax doc/external-auth
%doc doc/history doc/hook-perl doc/hook-python doc/hook-tcl doc/IPv6-info doc/sample-control
%defattr(2770,root,news)
%dir %_spooldir/news
%dir %_spooldir/news/articles
%dir %_spooldir/news/overview
%dir %_spooldir/news/archive
%dir %_spooldir/news/incoming
%dir %_spooldir/news/incoming/bad
%dir %_spooldir/news/outgoing
%dir %_spooldir/news/uniover
%dir %_spooldir/news/innfeed
%dir %_logdir/%name
%dir %_var/run/news
%dir %_var/run/news/tmp
%dir %_localstatedir/news

%attr(-,news,root) %config(noreplace) %_localstatedir/news/*
%attr(-,root,news) %dir %_sysconfdir/news
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/actsync.cfg
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/actsync.ign
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/buffindexed.conf
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/control.ctl
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/cycbuff.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/distrib.pats
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/expire.ctl
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/incoming.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/inn.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innfeed.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innreport.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/innwatch.ctl
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/moderators
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/motd.news
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/news2mail.cf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/newsfeeds
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/nnrp.access
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/nnrpd.track
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/nntpsend.ctl
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/ovdb.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/overview.fmt
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/passwd.nntp
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/radius.conf
%attr(640,root,news) %config(noreplace) %_sysconfdir/news/readers.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/sasl.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/storage.conf
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/subscriptions

%dir %attr(755,root,news) %_sysconfdir/news/filter
%attr(644,root,news) %config(noreplace) %_sysconfdir/news/filter/*

%%defattr(-,root,root)
%_man5dir/*
%_man8dir/*
%_libdir/%name/
%_bindir/ovdb_init
%_bindir/ovdb_monitor
%_bindir/ovdb_server
%_bindir/ovdb_stat
%_bindir/perl-nocem
%_bindir/tdx-util
%_bindir/innupgrade
%_bindir/ninpaths
%_bindir/innd
%_bindir/inndstart
%_bindir/nnrpd
%_bindir/innfeed
%_bindir/procbatch
%_bindir/startinnfeed
%_bindir/convdate
%_bindir/expire
%_bindir/expireover
%_bindir/expirerm
%_bindir/fastrm
%_bindir/grephistory
%_bindir/makedbz
%_bindir/makehistory
%_bindir/prunehistory
%_bindir/cnfsheadconf
%_bindir/cnfsstat
%_bindir/ctlinnd
%_bindir/getlist
%_bindir/innconfval
%_bindir/mailpost
%_bindir/pullnews
%_bindir/rnews
%_bindir/scanspool
%_bindir/signcontrol
%_bindir/sm
%_bindir/actmerge
%_bindir/actsync
%_bindir/actsyncd
%_bindir/archive
%_bindir/batcher
%_bindir/buffchan
%_bindir/controlbatch
%_bindir/controlchan
%_bindir/cvtbatch
%_bindir/filechan
%_bindir/gpgverify
%_bindir/inndf
%_bindir/innxmit
%_bindir/innxbatch
%_bindir/mod-active
%_bindir/news2mail
%_bindir/nntpget
%_bindir/nntpsend
%_bindir/overchan
%_bindir/pgpverify
%_bindir/send-ihave
%_bindir/send-nntp
%_bindir/send-uucp
%_bindir/sendxbatches
%_bindir/shlock
%_bindir/shrinkfile
%_bindir/inncheck
%_bindir/innmail
%_bindir/innreport
%_bindir/innstat
%_bindir/innwatch
%_bindir/news.daily
%_bindir/scanlogs
%_bindir/simpleftp
%_bindir/tally.control
%_bindir/writelog
%_bindir/docheckgroups
%_bindir/imapfeed
%_bindir/sendinpaths
%_man1dir/convdate.*
%_man1dir/fastrm.*
%_man1dir/getlist.*
%_man1dir/grephistory.*
%_man1dir/innconfval.*
%_man1dir/innfeed.*
%_man1dir/innmail.*
%_man1dir/nntpget.*
%_man1dir/rnews.*
%_man1dir/shlock.*
%_man1dir/shrinkfile.*
%_man1dir/startinnfeed.*
%_man1dir/simpleftp.*
%_man1dir/pgpverify.*
%_man1dir/sm.*
%_man1dir/pullnews.*
%_sysconfdir/cron.hourly/*
%_sysconfdir/cron.daily/*
%_sysconfdir/rc.d/init.d/*

%files -n lib%name
%_libdir/libinn.so.*
%_libdir/libstorage.so.*
%_libdir/libinnhist.so.*

%files -n lib%name-devel
%_libdir/libinn.so
%_libdir/libstorage.so
%_libdir/libinnhist.so
%_includedir/%name
%_man3dir/*

%files -n lib%name-devel-static
%_libdir/libinn.a
%_libdir/libstorage.a
%_libdir/libinnhist.a

%files -n inews
%_bindir/inews
%_man1dir/inews*

%changelog
